@section('title', __('Users'))
<div class="container-fluid" style="margin-top: 10px;">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header usuario_encabezado">
                    <div style="display: flex; justify-content: space-between; align-items: center;">
                        <div class="float-left">
                            <h4><i class="fa-fw fas fa-users text-info"></i>
                                Listado de Usuarios </h4>
                        </div>
                        @if (session()->has('message'))
                            <div wire:poll.4s class="btn btn-sm btn-success" style="margin-top:0px; margin-bottom:0px;">
                                {{ session('message') }} </div>
                        @endif
                        <div>
                            <input wire:model='keyWord' type="text" class="form-control" name="search"
                                id="search" placeholder="Buscar en Usuarios">
                        </div>
                        <div class="btn btn-sm btn-info" data-bs-toggle="modal" data-bs-target="#createDataModal">
                            <i class="fa fa-plus"></i> Agregar Usuarios
                        </div>
                    </div>
                </div>

                <div class="card-body">
                    @include('livewire.users.modals')
                    <div class="table-responsive">
                        <table class="table table-bordered table-sm">
                            <thead class="thead">
                                <tr>
                                    <td class="usuario_cuerpo">#</td>
                                    <th class="usuario_cuerpo">Dni</th>
                                    <th class="usuario_cuerpo">Nombres Y Apellidos</th>
                                    <th class="usuario_cuerpo">Email</th>
                                    <th class="usuario_cuerpo">Tipo</th>
                                    @auth
                                        @if (Auth::user()->Tipo === 'SuperAdministrador')
                                            <th class="usuario_cuerpo">Ugel</th>
                                        @endif
                                    @endauth
                                    <th class="usuario_cuerpo">Oficina</th>
                                    <td class="usuario_cuerpo">Elimnar</td>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($users as $row)
                                    <tr>
                                        <td data-bs-toggle="modal" data-bs-target="#updateDataModal"
                                            wire:click="edit({{ $row->DNI }})">{{ $loop->iteration }}</td>
                                        <td data-bs-toggle="modal" data-bs-target="#updateDataModal"
                                            wire:click="edit({{ $row->DNI }})">{{ $row->DNI }}</td>
                                        <td data-bs-toggle="modal" data-bs-target="#updateDataModal"
                                            wire:click="edit({{ $row->DNI }})">{{ $row->Nombres_y_Apellidos }}</td>
                                        <td data-bs-toggle="modal" data-bs-target="#updateDataModal"
                                            wire:click="edit({{ $row->DNI }})">{{ $row->email }}</td>
                                        <td data-bs-toggle="modal" data-bs-target="#updateDataModal"
                                            wire:click="edit({{ $row->DNI }})">{{ $row->Tipo }}</td>
                                        @auth
                                            @if (Auth::user()->Tipo === 'SuperAdministrador')
                                                <td data-bs-toggle="modal" data-bs-target="#updateDataModal"
                                                    wire:click="edit({{ $row->DNI }})">{{ $row->Nombre_Ugel }}</td>
                                            @endif
                                        @endauth
                                        <td data-bs-toggle="modal" data-bs-target="#updateDataModal"
                                            wire:click="edit({{ $row->DNI }})">{{ $row->Nombre_Oficina }}</td>
                                        <td width="90" style="cursor: pointer;">
                                            <a data-bs-toggle="modal" data-bs-target="#deleteConfirmationModal"
                                                class="dropdown-item"
                                                wire:click="confirmDelete({{ $row->DNI }})"><i
                                                    class="fa fa-trash"></i> Eliminar </a>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-center" colspan="100%">No data Found </td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                        <div class="float-end">{{ $users->links() }}</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
