<!-- Add Modal -->
<div wire:ignore.self class="modal fade" id="createDataModal" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="createDataModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header formulario_encabezado">
                <h5 class="modal-title" id="createDataModalLabel">Crear Nuevo Usuario</h5>
                <button wire:click.prevent="cancel()" type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
           <div class="modal-body formulario_cuerpo">
				<form>
                    <div class="form-group">
                        <label for="DNI" style="color: #800080; font-size: 13px;">DNI</label>
                        <input wire:model="DNI" type="text" class="form-control" id="DNI" placeholder="Dni">
                        @error('DNI')
                                <span class="error text-danger">{{ $message }}</span>
                            @else
                                <small class="form-text text-info">Campo obligatorio y formato DNI.</small>
                            @enderror
                    </div>
                    <div class="form-group">
                        <label for="Nombres_y_Apellidos" style="color: #800080; font-size: 13px;">NOMBRES Y APELLIDOS</label>
                        <input wire:model="Nombres_y_Apellidos" type="text" class="form-control" id="Nombres_y_Apellidos" placeholder="Nombres Y Apellidos">
                        @error('Nombres_y_Apellidos')
                                <span class="error text-danger">{{ $message }}</span>
                            @else
                                <small class="form-text text-info">Campo obligatorio, se recomienda un nombre Real.</small>
                            @enderror
                    </div>
                    <div class="form-group">
                        <label for="email" style="color: #800080; font-size: 13px;">CORREO ELECTRONICO</label>
                        <input wire:model="email" type="text" class="form-control" id="email" placeholder="Email">
                        @error('email')
                                <span class="error text-danger">{{ $message }}</span>
                            @else
                                <small class="form-text text-info">Campo obligatorio y formato Correo.</small>
                            @enderror
                    </div>
                    <div class="form-group">
                        <label for="Tipo" style="color: #800080; font-size: 13px;">TIPO</label>
                        @auth
                            @if (Auth::user()->Tipo === 'SuperAdministrador')
                            <select wire:model="Tipo" class="form-control" id="Tipo" placeholder="Tipo">
                                <option value="">Seleccion Tipo</option>
                                <option value="SuperAdministrador">SuperAdministrador</option>
                                <option value="Administrador">Administrador</option>
                                <option value="Tecnico">Tecnico</option>
                                <option value="Usuario">Usuario</option>
                            </select>  
                            @endif
                        @endauth
                        @auth
                            @if (Auth::user()->Tipo === 'Administrador')
                            <select wire:model="Tipo" class="form-control" id="Tipo" placeholder="Tipo">
                                <option value="">Seleccion Tipo</option>
                                <option value="Administrador">Administrador</option>
                                <option value="Tecnico">Tecnico</option>
                                <option value="Usuario">Usuario</option>
                            </select>
                            @endif
                        @endauth
                        @error('Tipo')
                            <span class="error text-danger">{{ $message }}</span>
                        @else
                            <small class="form-text text-info">Campo obligatorio.</small>
                        @enderror
                    </div>
                    @auth
                    @if (Auth::user()->Tipo === 'SuperAdministrador')
                    <div class="form-group">
                        <label for="ugelseleccionada" style="color: #800080;">UGEL</label>
                        <select wire:model="ugelseleccionada" class="form-control" id="ugelseleccionada"
                            placeholder="Ugel">
                            @error('ugelseleccionada')
                                <span class="error text-danger">{{ $message }}</span>
                            @enderror>
                            <option value="">Seleccionar Ugel</option>
                            @foreach ($ugeles as $ugel)
                                <option value="{{ $ugel->Cod_Ugel }}">{{ $ugel->Nombre_Ugel }}</option>
                            @endforeach
                        </select>
                        @error('ugelseleccionada')
                            <span class="error text-danger">{{ $message }}</span>
                        @else
                            <small class="form-text text-info">Campo obligatorio.</small>
                        @enderror
                    </div>    
                    @endif
                    @endauth
                    <div class="form-group">
                        <label for="Cod_Oficina" style="color: #800080;">OFICINA</label>
                        <select wire:model="Cod_Oficina" class="form-control" id="Cod_Oficina"
                            placeholder="Oficina">
                            @error('Cod_Oficina')
                                <span class="error text-danger">{{ $message }}</span>
                            @enderror>
                            <option value="">Seleccionar Oficina</option>
                            @foreach ($oficinas as $oficina)
                                <option value="{{ $oficina->Cod_Oficina }}">{{ $oficina->Nombre_Oficina }}</option>
                            @endforeach
                        </select>
                        @error('Cod_Oficina')
                            <span class="error text-danger">{{ $message }}</span>
                        @else
                            <small class="form-text text-info">Campo obligatorio.</small>
                        @enderror
                    </div>
                    <div class="form-group">
                        <label for="password" style="color: #800080; font-size: 13px;">CONTRASEÑA</label>
                        <input wire:model="password" type="text" class="form-control" id="password" placeholder="Contraseña">
                        @error('password')
                            <span class="error text-danger">{{ $message }}</span>
                        @else
                            <small class="form-text text-info">Campo obligatorio.</small>
                        @enderror
                    </div>

                </form>
            </div>
            <div class="modal-footer formulario_encabezado">
                <button type="button" class="btn btn-secondary close-btn" data-bs-dismiss="modal">Cerrar</button>
                <button type="button" wire:click.prevent="store()" class="btn btn-primary">Guardar</button>
            </div>
        </div>
    </div>
</div>

<!-- Edit Modal -->
<div wire:ignore.self class="modal fade" id="updateDataModal" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="updateModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header formulario_encabezado">
                <h5 class="modal-title" id="updateModalLabel">Actualizar Usuario</h5>
                <button wire:click.prevent="cancel()" type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body formulario_cuerpo">
                <form>
                    <div class="form-group">
                        <label for="DNI" style="color: #800080;">DNI</label>
                        <input wire:model="DNI" type="text" class="form-control" id="DNI" placeholder="Dni">
                        @error('DNI')
                            <span class="error text-danger">{{ $message }}</span>
                        @else
                            <small class="form-text text-info">Campo obligatorio y formato DNI</small>
                        @enderror
                    </div>
                    <div class="form-group">
                        <label for="Nombres_y_Apellidos" style="color: #800080;">NOMBRES Y APELLIDOS</label>
                        <input wire:model="Nombres_y_Apellidos" type="text" class="form-control" id="Nombres_y_Apellidos" placeholder="Nombres Y Apellidos">
                        @error('Nombres_y_Apellidos')
                            <span class="error text-danger">{{ $message }}</span>
                        @else
                            <small class="form-text text-info">Campo obligatorio</small>
                        @enderror
                    </div>
                    <div class="form-group">
                        <label for="email" style="color: #800080;">CORREO ELECTRONICO</label>
                        <input wire:model="email" type="text" class="form-control" id="email" placeholder="Email">
                        @error('email')
                            <span class="error text-danger">{{ $message }}</span>
                        @else
                            <small class="form-text text-info">Campo obligatorio y formato Correo.</small>
                        @enderror
                    </div>
                    <div class="form-group">
                        <label for="Tipo" style="color: #800080; font-size: 13px;">TIPO</label>
                        @auth
                            @if (Auth::user()->Tipo === 'SuperAdministrador')
                            <select wire:model="Tipo" class="form-control" id="Tipo" placeholder="Tipo">
                                <option value="">Seleccion Tipo</option>
                                <option value="SuperAdministrador">SuperAdministrador</option>
                                <option value="Administrador">Administrador</option>
                                <option value="Tecnico">Tecnico</option>
                                <option value="Usuario">Usuario</option>
                            </select>
                            @endif
                        @endauth
                        @auth
                            @if (Auth::user()->Tipo === 'Administrador')
                            <select wire:model="Tipo" class="form-control" id="Tipo" placeholder="Tipo">
                                <option value="">Seleccion Tipo</option>
                                <option value="Administrador">Administrador</option>
                                <option value="Tecnico">Tecnico</option>
                                <option value="Usuario">Usuario</option>
                            </select>
                            @endif
                        @endauth
                        @error('Tipo')
                            <span class="error text-danger">{{ $message }}</span>
                        @else
                            <small class="form-text text-info">Campo obligatorio</small>
                        @enderror
                    </div>
                    @auth
                        @if (Auth::user()->Tipo === 'SuperAdministrador')
                        <div class="form-group">
                            <label for="ugelseleccionada" style="color: #800080;">UGEL</label>
                            <select wire:model="ugelseleccionada" class="form-control" id="ugelseleccionada" placeholder="Ugel">
                                @error('ugelseleccionada')
                                    <span class="error text-danger">{{ $message }}</span>
                                @enderror
                                <option value="">Seleccionar Ugel</option>
                                @foreach ($ugeles as $ugel)
                                    <option value="{{ $ugel->Cod_Ugel }}">{{ $ugel->Nombre_Ugel }}</option>
                                @endforeach
                            </select>
                            @error('ugelseleccionada')
                                <span class="error text-danger">{{ $message }}</span>
                            @else
                                <small class="form-text text-info">Campo obligatorio</small>
                            @enderror
                        </div>
                        @endif
                    @endauth
                    <div class="form-group">
                        <label for="Cod_Oficina" style="color: #800080;">OFICINA</label>
                        <select wire:model="Cod_Oficina" class="form-control" id="Cod_Oficina" placeholder="Oficina">
                            <option value="">Seleccionar Oficina</option>
                            @foreach ($oficinas as $oficina)
                                <option value="{{ $oficina->Cod_Oficina }}">{{ $oficina->Nombre_Oficina }}</option>
                            @endforeach
                        </select>
                        @error('Cod_Oficina')
                            <span class="error text-danger">{{ $message }}</span>
                        @else
                            <small class="form-text text-info">Campo obligatorio</small>
                        @enderror
                    </div>
                    <div class="form-group">
                        <label for="password" style="color: #800080;">
                            <input wire:model="NuevaContraseña" type="checkbox">
                            NUEVA CONTRASEÑA</label>
                        <input wire:model="password" type="password" class="form-control" id="password" placeholder="Contraseña" {{ $NuevaContraseña ? '' : 'readonly disabled' }}>
                        @if ($NuevaContraseña)
                            @error('password')
                                <span class="error text-danger">{{ $message }}</span>
                            @else
                                <small class="form-text text-info">Campo obligatorio</small>
                            @enderror
                        @endif
                    </div>
                </form>
            </div>
            <div class="modal-footer formulario_encabezado">
                <button type="button" wire:click.prevent="cancel()" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
                <button type="button" wire:click.prevent="update()" class="btn btn-primary">Guardar</button>
            </div>
        </div>
    </div>
</div>
<!-- Delete confirmation modal -->
<div wire:ignore.self class="modal fade" id="deleteConfirmationModal" data-bs-backdrop="static" tabindex="-1" role="dialog"
    aria-labelledby="deleteConfirmationModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header formulario_encabezado">
                <h5 class="modal-title" id="deleteConfirmationModalLabel">Confirmar eliminación</h5>
                <button wire:click.prevent="cancel()" type="button" class="btn-close" data-bs-dismiss="modal"
                    aria-label="Close"></button>
            </div>
            <div class="modal-body fromulario_cuerpo">
                ¿Está seguro de que desea eliminar el Usuario con DNI: {{$DNI}} ?
            </div>
            <div class="modal-footer formulario_encabezado">
                <button type="button" wire:click.prevent="cancel()" class="btn btn-secondary"
                    data-bs-dismiss="modal">Cancelar</button>
                <button type="button" wire:click.prevent="destroy()" class="btn btn-primary" style="background: red;border-color:red">Eliminar</button>
            </div>
        </div>
    </div>
</div>