@section('title', __('Ugeles'))
<div class="container-fluid" style="margin-top: 10px;">
	<div class="row justify-content-center">
		<div class="col-md-12">
			<div class="card">
				<div class="card-header ugel_encabezado">
					<div style="display: flex; justify-content: space-between; align-items: center;">
						<div class="float-left">
							<h4><i class="fa-fw fas fa-pencil text-info"></i>
							Listado de Ugeles </h4>
						</div>
						@if (session()->has('message'))
						<div wire:poll.4s class="btn btn-sm btn-success" style="margin-top:0px; margin-bottom:0px;"> {{ session('message') }} </div>
						@endif
						<div>
							<input wire:model='keyWord' type="text" class="form-control" name="search" id="search" placeholder="Buscar en Ugeles">
						</div>
						@auth
						@if(Auth::user()->Tipo==="SuperAdministrador")
						<div class="btn btn-sm btn-info" data-bs-toggle="modal" data-bs-target="#createDataModal">
						<i class="fa fa-plus"></i>  Agregar Ugeles
						</div>
						@endif
						@endauth
					</div>
				</div>
				
				<div class="card-body">
						@include('livewire.ugeles.modals')
				<div class="table-responsive">
					<table class="table table-bordered table-sm">
						<thead class="thead">
							<tr> 
								<td class="ugel_cuerpo">#</td> 
								<th class="ugel_cuerpo">Cod Ugel</th>
								<th class="ugel_cuerpo">Nombre Ugel</th>
								<th class="ugel_cuerpo">Logo</th>
								<td class="ugel_cuerpo">Eliminar</td>
							</tr>
						</thead>
						<tbody>
							@forelse($ugeles as $row)
							<tr>
								<td	data-bs-toggle="modal" data-bs-target="#updateDataModal" wire:click="edit({{$row->Cod_Ugel}})">{{ $loop->iteration }}</td> 
								<td	data-bs-toggle="modal" data-bs-target="#updateDataModal" wire:click="edit({{$row->Cod_Ugel}})">{{ $row->Cod_Ugel }}</td>
								<td	data-bs-toggle="modal" data-bs-target="#updateDataModal" wire:click="edit({{$row->Cod_Ugel}})">{{ $row->Nombre_Ugel }}</td>
								<td	data-bs-toggle="modal" data-bs-target="#updateDataModal" wire:click="edit({{$row->Cod_Ugel}})">
									<div class="image-box">
										<!-- Mostrar la imagen desde la ruta almacenada en $this->Imagen -->
										@if ($row->Logo)
											<img class="image-preview" src="{{ asset('storage/' . $row->Logo) }}?{{ uniqid() }}" style="height: 100px;" alt="Imagen">
										@endif
									</div>
								</td>
								<td width="90" style="cursor: pointer;">
									<a data-bs-toggle="modal" data-bs-target="#deleteConfirmationModal"
										class="dropdown-item"
										wire:click="confirmDelete({{ $row->Cod_Ugel }})"><i
											class="fa fa-trash"></i> Eliminar </a>
								</td>
							</tr>
							@empty
							<tr>
								<td class="text-center" colspan="100%">No data Found </td>
							</tr>
							@endforelse
						</tbody>
					</table>						
					<div class="float-end">{{ $ugeles->links() }}</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>