<!-- Add Modal -->
<div wire:ignore.self class="modal fade" id="createDataModal" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="createDataModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header formulario_encabezado">
                <h5 class="modal-title" id="createDataModalLabel">Crear Nueva Ugel</h5>
                <button wire:click.prevent="cancel()" type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
           <div class="modal-body formulario_cuerpo">
				<form>
                    <div class="form-group">
                        <label for="Cod_Ugel" style="color: #800080; font-size: 13px;">CODIGO UGEL</label>
                        <input wire:model="Cod_Ugel" type="text" class="form-control" id="Cod_Ugel" placeholder="Cod Ugel">
                        @error('Cod_Ugel')
                                <span class="error text-danger">{{ $message }}</span>
                            @else
                                <small class="form-text text-info">Campo obligatorio y de formato RUC.</small>
                            @enderror
                    </div>
                    <div class="form-group">
                        <label for="Nombre_Ugel" style="color: #800080; font-size: 13px;">NOMBRE UGEL</label>
                        <input wire:model="Nombre_Ugel" type="text" class="form-control" id="Nombre_Ugel" placeholder="Nombre Ugel">
                        @error('Nombre_Ugel')
                                <span class="error text-danger">{{ $message }}</span>
                            @else
                                <small class="form-text text-info">Campo obligatorio, maximo 255 caracteres.</small>
                            @enderror
                    </div>
                    <div>
                        <div class="form-group">
                            <label for="imagenInput" style="color: #800080; font-size: 13px;">LOGO</label>
                            <input wire:model="imagenInput" type="file" class="form-control" id="imagenInput">
                            @error('imagenInput')
                                <span class="error text-danger">{{ $message }}</span>
                            @else
                                <small class="form-text">Maximo 500KB.</small>
                            @enderror
                        </div>
                        <div class="image-box">
                            <!-- Mostrar la imagen con tamaño predeterminado -->
                            @if ($imagenInput && $imagenInput instanceof Livewire\TemporaryUploadedFile && in_array($imagenInput->getClientOriginalExtension(), ['jpg', 'jpeg', 'png', 'gif']))
                                <img class="image-preview" src="{{ $imagenInput->temporaryUrl() }}" alt="Imagen">
                            @endif
                        </div>
                    </div>

                </form>
            </div>
            <div class="modal-footer formulario_encabezado">
                <button type="button" class="btn btn-secondary close-btn" data-bs-dismiss="modal">Cerrar</button>
                <button type="button" wire:click.prevent="store()" class="btn btn-primary">Guardar</button>
            </div>
        </div>
    </div>
</div>

<!-- Edit Modal -->
<div wire:ignore.self class="modal fade" id="updateDataModal" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="updateModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
       <div class="modal-content">
            <div class="modal-header formulario_encabezado">
                <h5 class="modal-title" id="updateModalLabel">Actualizar Ugel</h5>
                <button wire:click.prevent="cancel()" type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body formulario_cuerpo">
                <form>
					<input type="hidden" wire:model="selected_id">
                    <div class="form-group" style="color: #800080; font-size: 13px;">
                        <label for="Cod_Ugel">CODIGO UGEL</label>
                        <input wire:model="Cod_Ugel" type="text" class="form-control" id="Cod_Ugel" placeholder="Cod Ugel">
                        @error('Cod_Ugel')
                                <span class="error text-danger">{{ $message }}</span>
                            @else
                                <small class="form-text text-info">Campo obligatorio y de formato RUC.</small>
                            @enderror
                    </div>
                    <div class="form-group" style="color: #800080; font-size: 13px;">
                        <label for="Nombre_Ugel">NOMBRE UGEL</label>
                        <input wire:model="Nombre_Ugel" type="text" class="form-control" id="Nombre_Ugel" placeholder="Nombre Ugel">
                        @error('Nombre_Ugel')
                                <span class="error text-danger">{{ $message }}</span>
                            @else
                                <small class="form-text text-info">Campo obligatorio, maximo 255 caracteres.</small>
                            @enderror
                    </div>
                    <div>
                        <div class="form-group">
                            <label for="imagenInput" style="color: #800080; font-size: 13px;">LOGO</label>
                            <input wire:model="imagenInput" type="file" class="form-control" id="imagenInput"  accept="image/jpeg, image/png">
                            @error('imagenInput')
                                <span class="error text-danger">{{ $message }}</span>
                            @else
                                <small class="form-text">Maximo 500KB.</small>
                            @enderror
                        </div>
                        <div class="image-box">
                            <!-- Mostrar la imagen con tamaño predeterminado -->
                            @if ($imagenInput && $imagenInput instanceof Livewire\TemporaryUploadedFile && in_array($imagenInput->getClientOriginalExtension(), ['jpg', 'jpeg', 'png', 'gif']))
                                <img class="image-preview" src="{{ $imagenInput->temporaryUrl() }}"
                                    alt="Imagen">
                            @else
                                <img class="image-preview" src="{{ asset('storage/' . $Logo) }}?{{ uniqid() }}" alt="Imagen">
                            @endif
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer formulario_encabezado">
                <button type="button" wire:click.prevent="cancel()" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
                <button type="button" wire:click.prevent="update()" class="btn btn-primary">Guardar</button>
            </div>
       </div>
    </div>
</div>
<!-- Delete confirmation modal -->
<div wire:ignore.self class="modal fade" id="deleteConfirmationModal" data-bs-backdrop="static" tabindex="-1" role="dialog"
    aria-labelledby="deleteConfirmationModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header formulario_encabezado">
                <h5 class="modal-title" id="deleteConfirmationModalLabel">Confirmar eliminación</h5>
                <button wire:click.prevent="cancel()" type="button" class="btn-close" data-bs-dismiss="modal"
                    aria-label="Close"></button>
            </div>
            <div class="modal-body formulario_cuerpo">
                ¿Está seguro de que desea eliminar la Ugel con Codigo: {{$Cod_Ugel}} ?
            </div>
            <div class="modal-footer formulario_encabezado">
                <button type="button" wire:click.prevent="cancel()" class="btn btn-secondary"
                    data-bs-dismiss="modal">Cancelar</button>
                <button type="button" wire:click.prevent="destroy()" class="btn btn-primary" style="background: red;border-color:red">Eliminar</button>
            </div>
        </div>
    </div>
</div>
