@section('title', __('Tickets'))

<div class="container-fluid" style="margin-top: 10px;">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header ticket_encabezado">
                    <div style="display: flex; justify-content: space-between; align-items: center;">
                        <div class="float-left">
                            <h4><i class="fa-fw fas fa-ticket text-info"></i> Tickets </h4>
                        </div>
                        @if (session()->has('message'))
                            <div wire:poll.4s class="btn btn-sm btn-success" style="margin-top:0px; margin-bottom:0px;">
                                {{ session('message') }} </div>
                        @endif
                        <div>
                            <input wire:model='keyWord' type="text" class="form-control" name="search"
                                id="search" placeholder="Buscar en Tickets">
                        </div>
                    </div>
                </div>

                <div class="card-body ticket_cuerpo">
                    @include('livewire.tickets.modals')
                    <div class="row">
                        @forelse($registros as $row)
                            <div class="col-md-3 mb-3">
                                <div class="card texto_gris" data-bs-toggle="modal" data-bs-target="#updateDataModal"
                                    wire:click="edit('{{ $row->Cod_Registro }}')"
                                    @if ($row->Prioridad === 'Alta') style="cursor: pointer;background: red;" @endif
                                    @if ($row->Prioridad === 'Media') style="cursor: pointer;background: yellow;" @endif
                                    @if ($row->Prioridad === 'Baja') style="cursor: pointer;background: green;" @endif>
                                    <div class="ticket-number-badge">
                                        <span class="badge-number">{{ $row->enumeration }}</span>
                                    </div>
                                    <div class="card-body p-1">
                                        <h5 class="card-title">{{ $row->Fecha_Inicio }}</h5>
                                        <div class="image-box">
                                            @if ($row->Imagen)
                                            <img class="image-preview" src="{{ asset('storage/' . $row->Imagen) }}?{{ uniqid() }}" style="width: 100%;" alt="Imagen">
                                            @endif
                                        </div>
                                        <p class="card-text mb-0">Tipo de Soporte:{{ $row->Tipo_Soporte }}</p>
                                        <p class="card-text mb-0">Servicio: {{ $row->Nombre }}</p>
                                        <p class="card-text mb-0">Usuario: {{ $row->Nombres_y_Apellidos_Usuario }}</p>
                                        <p class="card-text mb-0">Tecnico Asignado: {{ $row->Nombres_y_Apellidos_Tecnico }}</p>
                                        <p class="card-text mb-0">Prioridad: {{ $row->Prioridad }}</p>
                                        <p class="card-text mb-0">Estado: {{ $row->Estado }}</p>
                                    </div>
                                </div>
                            </div>
                        @empty
                            <div class="col-md-12">
                                <p class="text-center">No data Found</p>
                            </div>
                        @endforelse
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
