
<!-- Edit Modal -->
<div wire:ignore.self class="modal fade" id="updateDataModal" data-bs-backdrop="static" tabindex="-1"
    role="dialog" aria-labelledby="updateModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl" role="document">
        <div class="modal-content">
            <div class="modal-header formulario_encabezado">
                <h5 class="modal-title" id="updateModalLabel">Actualizar Registro {{$Cod_Registro}} </h5>
                <button wire:click.prevent="cancel()" type="button" class="btn-close" data-bs-dismiss="modal"
                    aria-label="Close"></button>
            </div>
            <div class="modal-body formulario_cuerpo">
                <form>
                    <div class="row">
                                <div class="form-group col-md-4">
                                    <label for="Cod_Ugel" style="color: #800080;">UGEL</label>
                                    <select wire:model="Cod_Ugel" class="form-control" id="Cod_Ugel"
                                        placeholder="Ugel"
                                        @if (Auth::user()->Tipo !== "SuperAdministrador") disabled wire:ignore @endif>
                                        <option value="">Seleccionar Ugel</option>
                                        @foreach ($ugeles as $ugel)
                                            <option value="{{ $ugel->Cod_Ugel }}">{{ $ugel->Nombre_Ugel }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-group col-md-4">
                                    <label for="Cod_Oficina" style="color: #800080;">OFICINA</label>
                                    <select wire:model="Cod_Oficina" class="form-control" id="Cod_Oficina"
                                        placeholder="Oficina"
                                        @if (Auth::user()->Tipo !== "SuperAdministrador") disabled @endif>
                                        <option value="">Seleccionar Oficina</option>
                                        @foreach ($oficinas as $oficina)
                                            <option value="{{ $oficina->Cod_Oficina }}">{{ $oficina->Nombre_Oficina }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-group col-md-4">
                                    <label for="Usuario" style="color: #800080;">USUARIO</label>
                                    <select wire:model="Usuario" class="form-control" id="Usuario"
                                        placeholder="Usuario"
                                        @if (Auth::user()->Tipo !== "SuperAdministrador") disabled @endif>
                                        <option value="">Seleccionar Usuario</option>
                                        @foreach ($usuarios as $usuario)
                                            <option value="{{ $usuario->DNI }}">{{ $usuario->Nombres_y_Apellidos }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                    </div>
                    <div class="row">
                        <div class="form-group col-md-6">
                            <label for="Descripcion_problema" style="color: #800080; font-size: 13px;">DESCRIPCION
                                PROBLEMA</label>
                            <textarea wire:model="Descripcion_problema" class="form-control" id="Descripcion_problema"
                                placeholder="Descripcion Problema" rows="8" @if(Auth::user()->Tipo === 'Tecnico' ||
                                Auth::user()->Tipo === 'Administrador'
                                || (Auth::user()->Tipo !== "SuperAdministrador" && $Estado==="Terminado")) disabled @endif></textarea>
                            @error('Descripcion_problema')
                            <span class="error text-danger">{{ $message }}</span>
                        @else
                        @auth
                            @if(Auth::user()->Tipo==="Usuario" || Auth::user()->Tipo==="SuperAdministrador")
                                <small class="error text-info">Maximo 255 caracteres.</small>
                            @endif
                        @endauth
                        @enderror
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label style="color: #800080;">TIPO DE SOPORTE</label>
                                <div class="horizontal-options">
                                    <label class="custom-option">
                                        <input type="radio" wire:model="Tipo_Soporte"
                                            value="Virtual" @if(Auth::user()->Tipo === 'Tecnico' ||
                                            Auth::user()->Tipo === 'Administrador'
                                            || (Auth::user()->Tipo !== "SuperAdministrador" && $Estado==="Terminado")) wire:ignore disabled @endif>
                                        <div class="option-border">Virtual</div>
                                    </label>
                                    <label class="custom-option">
                                        <input type="radio" wire:model="Tipo_Soporte" 
                                            value="Presencial" @if(Auth::user()->Tipo === 'Tecnico' ||
                                            Auth::user()->Tipo === 'Administrador'
                                            || (Auth::user()->Tipo !== "SuperAdministrador" && $Estado==="Terminado")) wire:ignore disabled @endif>
                                        <div class="option-border">Presencial</div>
                                    </label>
                                </div>
                                 @error('Tipo_Soporte')
                                    <span class="error text-danger">{{ $message }}</span>
                                @else
                                @auth
                                @if(Auth::user()->Tipo==="Usuario" || Auth::user()->Tipo==="SuperAdministrador")
                                    <small class="error text-info">Selecciona una opción.</small>
                                @endif
                                @endauth
                                @enderror
                            </div>

                            <div class="form-group">
                                <label style="color: #800080;">PRIORIDAD</label>
                                <div class="vertical-options">
                                    <label class="custom-option">
                                        <input type="radio" wire:model="Prioridad" value="Alta" 
                                        @if (Auth::user()->Tipo !== "SuperAdministrador" && Auth::user()->Tipo !== "Administrador") disabled wire:ignore @endif>
                                        <div class="option-border alta">Alta</div>
                                    </label>
                                    <label class="custom-option">
                                        <input type="radio" wire:model="Prioridad" value="Media"
                                        @if (Auth::user()->Tipo !== "SuperAdministrador" && Auth::user()->Tipo !== "Administrador") disabled wire:ignore @endif>
                                        <div class="option-border media">Media</div>
                                    </label>
                                    <label class="custom-option">
                                        <input type="radio" wire:model="Prioridad" value="Baja"
                                        @if (Auth::user()->Tipo !== "SuperAdministrador" && Auth::user()->Tipo !== "Administrador") disabled wire:ignore @endif>
                                        <div class="option-border baja">Baja</div>
                                    </label>
                                </div>
                                @error('Prioridad')
                                    <span class="error text-danger">{{ $message }}</span>
                                @else
                                @auth
                                @if(Auth::user()->Tipo==="SuperAdministrador" || Auth::user()->Tipo==="Administrador")
                                    <small class="error text-info">Selecciona una opción.</small>
                                @endif
                                @endauth
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="imagenInput" style="color: #800080; font-size: 13px;">IMAGEN</label>
                                <input wire:model="imagenInput" type="file" class="form-control" id="imagenInput"  accept="image/jpeg, image/png"
                                    @if (Auth::user()->Tipo === 'Tecnico' ||
                                            Auth::user()->Tipo === 'Administrador' ||
                                            (Auth::user()->Tipo !== 'SuperAdministrador' && $Estado === 'Terminado')) disabled wire:ignore @endif>
                                @error('imagenInput')
                                <span class="error text-danger">{{ $message }}</span>
                            @else
                            @auth
                                @if(Auth::user()->Tipo==="Usuario" || Auth::user()->Tipo==="SuperAdministrador")
                                    <small class="error text-info">Maximo 500KB.</small>
                                @endif
                            @endauth
                            @enderror
                            </div>
                            <div class="image-box">
                                <!-- Mostrar la imagen con tamaño predeterminado -->
                                @if ($imagenInput && $imagenInput instanceof Livewire\TemporaryUploadedFile && in_array($imagenInput->getClientOriginalExtension(), ['jpg', 'jpeg', 'png', 'gif']))
                                    <img class="image-preview" src="{{ $imagenInput->temporaryUrl() }}"
                                        alt="Imagen">
                                @else
                                    <img class="image-preview" src="{{ asset('storage/' . $Imagen) }}?{{ uniqid() }}" alt="Imagen">
                                @endif
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <label style="color: #800080;">SERVICIOS HARDWARE</label>
                        <div class="options-grid">
                            @foreach ($servicios_hardware as $servicio)
                                <label class="custom-option">
                                    <input type="radio" wire:model="Servicio"
                                        value="{{ $servicio->Cod_Servicio }}"
                                        @if(Auth::user()->Tipo === 'Tecnico' ||
                                        Auth::user()->Tipo === 'Administrador'
                                        || (Auth::user()->Tipo !== "SuperAdministrador" && $Estado==="Terminado")) wire:ignore disabled @endif>
                                    <div class="option-border">{{ $servicio->Nombre }}</div>
                                </label>
                            @endforeach
                        </div>
                    </div>
                    <div class="form-group">
                        <label style="color: #800080;">SERVICIOS SOFTWARE</label>
                        <div class="options-grid">
                            @foreach ($servicios_software as $servicio)
                                <label class="custom-option">
                                    <input type="radio" wire:model="Servicio"
                                        value="{{ $servicio->Cod_Servicio }}"
                                        @if(Auth::user()->Tipo === 'Tecnico' ||
                                        Auth::user()->Tipo === 'Administrador'
                                        || (Auth::user()->Tipo !== "SuperAdministrador" && $Estado==="Terminado")) wire:ignore disabled @endif>
                                    <div class="option-border">{{ $servicio->Nombre }}</div>
                                </label>
                            @endforeach
                        </div>
                        @error('Servicio')
                            <span class="error text-danger">{{ $message }}</span>
                        @else
                        @auth
                            @if(Auth::user()->Tipo==="Usuario" || Auth::user()->Tipo==="SuperAdministrador")
                            <small class="error text-info">Selecciona un servicio.</small>
                            @endif
                        @endauth
                        @enderror
                    </div>
                    <div class="row">
                        <div class="form-group col-md-3">
                            <label for="Tecnico_asignado" style="color: #800080;">TECNICO ASIGNADO</label>
                            <select wire:model="Tecnico_asignado" class="form-control" id="Tecnico_asignado"
                                placeholder="Tecnico Asignado"
                                @if (Auth::user()->Tipo !== "SuperAdministrador" && Auth::user()->Tipo !== "Administrador") disabled wire:ignore @endif>
                                <option value="">Seleccionar Tecnico</option>
                                @foreach ($tecnicos as $tecnico)
                                    <option value="{{ $tecnico->DNI }}">{{ $tecnico->Nombres_y_Apellidos }}</option>
                                @endforeach
                            </select>
                            @error('Tecnico_asignado')
                                <span class="error text-danger">{{ $message }}</span>
                            @else
                            @auth
                                @if(Auth::user()->Tipo==="Administrador" || Auth::user()->Tipo==="Administrador")
                                <small class="error text-info">Seleccione un Tecnico.</small>
                                @endif
                            @endauth
                            @enderror
                        </div>
                        <div class="form-group col-md-3">
                            <label for="Estado" style="color: #800080; font-size: 13px;">ESTADO</label>
                            <select wire:model="Estado" class="form-control" id="Estado" 
                                @if(Auth::user()->Tipo !== "SuperAdministrador") disabled wire:ignore @endif>
                                <option value="">Seleccionar Estado</option>
                                <option value="Recibido">Recibido</option>
                                <option value="Proceso">Proceso</option>
                                <option value="Terminado">Terminado</option>
                            </select>
                            @error('Estado')
                                <span class="error text-danger">{{ $message }}</span>
                            @enderror
                        </div>
                        <div class="form-group col-md-3">
                            <label for="Fecha_Inicio" style="color: #800080; font-size: 13px;">FECHA INICIO</label>
                            <input wire:model="Fecha_Inicio" type="datetime-local" class="form-control" id="Fecha_Inicio"
                                placeholder="Fecha Inicio" 
                                @if(Auth::user()->Tipo !== "SuperAdministrador") disabled wire:ignore @endif>
                            @error('Fecha_Inicio')
                                <span class="error text-danger">{{ $message }}</span>
                            @enderror
                        </div>
                        <div class="form-group col-md-3">
                            <label for="Fecha_Final" style="color: #800080; font-size: 13px;">FECHA FINAL</label>
                            <input wire:model="Fecha_Final" type="datetime-local" class="form-control" id="Fecha_Final"
                                    
                                @if(Auth::user()->Tipo !== "SuperAdministrador") disabled wire:ignore @endif>
                            @error('Fecha_Final')
                                <span class="error text-danger">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="Solucion" style="color: #800080; font-size: 13px;">SOLUCION</label>
                        <textarea wire:model="Solucion" class="form-control" id="Solucion" placeholder="Solucion" rows="4"
                            @if (Auth::user()->Tipo === 'Administrador' ||
                                    Auth::user()->Tipo === 'Usuario'
                                    || (Auth::user()->Tipo !== "SuperAdministrador" && $Estado==="Terminado")) disabled wire:ignore @endif>
                </textarea>
                        @error('Solucion')
                                <span class="error text-danger">{{ $message }}</span>
                            @else
                            @auth
                                @if(Auth::user()->Tipo==="SuperAdministrador" || Auth::user()->Tipo==="Tecnico")
                                <small class="error text-info">Maximo 255 caracteres.</small>
                                @endif
                            @endauth
                        @enderror
                    </div>
                </form>
            </div>
            <div class="modal-footer formulario_encabezado">
                <button type="button" wire:click.prevent="cancel()" class="btn btn-secondary"
                    data-bs-dismiss="modal">Cerrar</button>
                <button type="button" wire:click.prevent="update()" class="btn btn-primary">Guardar</button>
            </div>
        </div>
    </div>
</div>
