@section('title', __('Servicios'))
<div class="container-fluid" style="margin-top: 10px;">
	<div class="row justify-content-center">
		<div class="col-md-12">
			<div class="card">
				<div class="card-header servicio_encabezado">
					<div style="display: flex; justify-content: space-between; align-items: center;">
						<div class="float-left">
							<h4><i class="bi bi-wrench text-info"></i>
							Listado de Servicios </h4>
						</div>
						@if (session()->has('message'))
						<div wire:poll.4s class="btn btn-sm btn-success" style="margin-top:0px; margin-bottom:0px;"> {{ session('message') }} </div>
						@endif
						<div>
							<input wire:model='keyWord' type="text" class="form-control" name="search" id="search" placeholder="Buscar en Servicios">
						</div>
						<div class="btn btn-sm btn-info ugel_encabezado" data-bs-toggle="modal" data-bs-target="#createDataModal">
						<i class="fa fa-plus"></i>  Agregar Servicios
						</div>
					</div>
				</div>
				
				<div class="card-body">
						@include('livewire.servicios.modals')
				<div class="table-responsive">
					<table class="table table-bordered table-sm">
						<thead class="thead">
							<tr> 
								<td class="servicio_cuerpo">#</td> 
								<th class="servicio_cuerpo">Cod Servicio</th>
								<th class="servicio_cuerpo">Cod Ugel</th>
								<th class="servicio_cuerpo">Nombre</th>
								<th class="servicio_cuerpo">Tipo</th>
								<td class="servicio_cuerpo">Eliminar</td>
							</tr>
						</thead>
						<tbody>
							@forelse($servicios as $row)
							<tr>
								<td data-bs-toggle="modal" data-bs-target="#updateDataModal" wire:click="edit('{{ $row->Cod_Servicio }}')">{{ $loop->iteration }}</td> 
								<td data-bs-toggle="modal" data-bs-target="#updateDataModal" wire:click="edit('{{ $row->Cod_Servicio }}')">{{ $row->Cod_Servicio }}</td>
								<td data-bs-toggle="modal" data-bs-target="#updateDataModal" wire:click="edit('{{ $row->Cod_Servicio }}')">{{ $row->Cod_Ugel }}</td>
								<td data-bs-toggle="modal" data-bs-target="#updateDataModal" wire:click="edit('{{ $row->Cod_Servicio }}')">{{ $row->Nombre }}</td>
								<td data-bs-toggle="modal" data-bs-target="#updateDataModal" wire:click="edit('{{ $row->Cod_Servicio }}')">{{ $row->Tipo }}</td>
								<td width="90" style="cursor: pointer;">
									<a data-bs-toggle="modal" data-bs-target="#deleteConfirmationModal"
										class="dropdown-item"
										wire:click="confirmDelete('{{ $row->Cod_Servicio }}')"><i
											class="fa fa-trash"></i> Eliminar </a>
								</td>
							</tr>
							@empty
							<tr>
								<td class="text-center" colspan="100%">No data Found </td>
							</tr>
							@endforelse
						</tbody>
					</table>						
					<div class="float-end">{{ $servicios->links() }}</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>