<!-- Add Modal -->
<div wire:ignore.self class="modal fade" id="createDataModal" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="createDataModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header formulario_encabezado">
                <h5 class="modal-title" id="createDataModalLabel">Crear Nuevo Servicio</h5>
                <button wire:click.prevent="cancel()" type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
           <div class="modal-body formulario_cuerpo">
				<form>
                    <div class="form-group">
                        <label for="Cod_Servicio" style="color: #800080;">COD SERVICIO</label>
                        <input wire:model="Cod_Servicio" type="text" class="form-control" id="Cod_Servicio" placeholder="Cod Servicio">
                        @error('Cod_Servicio')
                            <span class="error text-danger">{{ $message }}</span>
                        @else
                            <small class="form-text text-info">Campo obligatorio.</small>
                        @enderror
                    </div>
                    @auth
                            @if (Auth::user()->Tipo === 'SuperAdministrador')
                                <div class="form-group">
                                    <label for="Cod_Ugel" style="color: #800080;">UGEL</label>
                                    <select wire:model="Cod_Ugel" class="form-control" id="Cod_Ugel" placeholder="Ugel">
                                        <option value="">Seleccionar Ugel</option>
                                        @foreach ($ugeles as $ugel)
                                            <option value="{{ $ugel->Cod_Ugel }}">{{ $ugel->Nombre_Ugel }}</option>
                                        @endforeach
                                    </select>
                                    @error('Cod_Ugel')
                                        <span class="error text-danger">{{ $message }}</span>
                                    @else
                                        <small class="form-text text-info">Campo obligatorio.</small>
                                    @enderror
                                </div>
                            @endif
                    @endauth
                    <div class="form-group">
                        <label for="Nombre" style="color: #800080;">NOMBRE</label>
                        <input wire:model="Nombre" type="text" class="form-control" id="Nombre" placeholder="Nombre">
                        @error('Nombre')
                            <span class="error text-danger">{{ $message }}</span>
                        @else
                            <small class="form-text text-info">Campo obligatorio.</small>
                        @enderror
                    </div>
                    <div class="form-group">
                        <label for="Tipo" style="color: #800080;">TIPO</label>
                        <select wire:model="Tipo" class="form-control" id="Tipo">
                            <option value="">Seleccionar Tipo</option>
                            <option value="Hardware">Hardware</option>
                            <option value="Software">Software</option>
                        </select>
                        @error('Tipo')
                            <span class="error text-danger">{{ $message }}</span>
                        @else
                            <small class="form-text text-info">Seleccione un Tipo..</small>
                        @enderror
                    </div>

                </form>
            </div>
            <div class="modal-footer formulario_encabezado">
                <button type="button" class="btn btn-secondary close-btn" data-bs-dismiss="modal">Cerrar</button>
                <button type="button" wire:click.prevent="store()" class="btn btn-primary">Guardar</button>
            </div>
        </div>
    </div>
</div>

<!-- Edit Modal -->
<div wire:ignore.self class="modal fade" id="updateDataModal" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="updateModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
       <div class="modal-content">
            <div class="modal-header formulario_encabezado">
                <h5 class="modal-title" id="updateModalLabel">Actualizar Servicio</h5>
                <button wire:click.prevent="cancel()" type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body formulario_cuerpo">
                <form>
					<input type="hidden" wire:model="selected_id">
                    <div class="form-group">
                        <label for="Cod_Servicio" style="color: #800080;">COD SERVICIO</label>
                        <input wire:model="Cod_Servicio" type="text" class="form-control" id="Cod_Servicio" placeholder="Cod Servicio">
                        @error('Cod_Servicio')
                            <span class="error text-danger">{{ $message }}</span>
                        @else
                            <small class="form-text text-info">Campo obligatorio.</small>
                        @enderror
                    </div>
                    @auth
                            @if (Auth::user()->Tipo === 'SuperAdministrador')
                                <div class="form-group">
                                    <label for="Cod_Ugel" style="color: #800080;">UGEL</label>
                                    <select wire:model="Cod_Ugel" class="form-control" id="Cod_Ugel" placeholder="Ugel">
                                        <option value="">Seleccionar Ugel</option>
                                        @foreach ($ugeles as $ugel)
                                            <option value="{{ $ugel->Cod_Ugel }}">{{ $ugel->Nombre_Ugel }}</option>
                                        @endforeach
                                    </select>
                                    @error('Cod_Ugel')
                                        <span class="error text-danger">{{ $message }}</span>
                                    @else
                                        <small class="form-text text-info">Campo obligatorio.</small>
                                    @enderror
                                </div>
                            @endif
                    @endauth
                    <div class="form-group">
                        <label for="Nombre" style="color: #800080;">NOMBRE</label>
                        <input wire:model="Nombre" type="text" class="form-control" id="Nombre" placeholder="Nombre">
                        @error('Nombre')
                            <span class="error text-danger">{{ $message }}</span>
                        @else
                            <small class="form-text text-info">Campo obligatorio.</small>
                        @enderror
                    </div>
                    <div class="form-group">
                        <label for="Tipo" style="color: #800080;">TIPO</label>
                        <select wire:model="Tipo" class="form-control" id="Tipo">
                            <option value="">Seleccionar Tipo</option>
                            <option value="Hardware">Hardware</option>
                            <option value="Software">Software</option>
                        </select>
                        @error('Tipo')
                            <span class="error text-danger">{{ $message }}</span>
                        @else
                            <small class="form-text text-info">Seleccione un Tipo..</small>
                        @enderror
                    </div>
                </form>
            </div>
            <div class="modal-footer formulario_encabezado">
                <button type="button" wire:click.prevent="cancel()" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
                <button type="button" wire:click.prevent="update()" class="btn btn-primary">Guardar</button>
            </div>
       </div>
    </div>
</div>
<!-- Delete confirmation modal -->
<div wire:ignore.self class="modal fade" id="deleteConfirmationModal" data-bs-backdrop="static" tabindex="-1"
    role="dialog" aria-labelledby="deleteConfirmationModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header formulario_encabezado">
                <h5 class="modal-title" id="deleteConfirmationModalLabel">Confirmar eliminación</h5>
                <button wire:click.prevent="cancel()" type="button" class="btn-close" data-bs-dismiss="modal"
                    aria-label="Close"></button>
            </div>
            <div class="modal-body formulario_cuerpo">
                ¿Está seguro de que desea eliminar el Servicio con Codigo {{ $Cod_Servicio }} ?
            </div>
            <div class="modal-footer formulario_encabezado">
                <button type="button" wire:click.prevent="cancel()" class="btn btn-secondary"
                    data-bs-dismiss="modal">Cancelar</button>
                <button type="button" wire:click.prevent="destroy()" class="btn btn-primary"
                    style="background: red;border-color:red">Eliminar</button>
            </div>
        </div>
    </div>
</div>

