@section('title', __('Registros'))
<div class="container-fluid" style="margin-top: 10px">
    <div class="row justify-content-center">
        <div class="col-md-12 mb-5">
            <div class="card">
                <div class="card-header registro_encabezado">
                    <div style="display: flex;justify-content: space-between; align-items: center;">
                        <div class="float-left texto_blanco">
                            <h4><i class="fa fa-bars text-info"></i>
                                Listado de Registros </h4>
                        </div>
                        @if (session()->has('message'))
                            <div wire:poll.4s class="btn btn-sm btn-success" style="margin-top:0px; margin-bottom:0px;">
                                {{ session('message') }} </div>
                        @endif
                        <div>
                            <input wire:model='keyWord' type="text" class="form-control" name="search"
                                id="search" placeholder="Buscar en Registros">
                        </div>
                        @auth
                        @if(Auth::user()->Tipo==="Usuario")
                        <div class="btn btn-sm btn-info" data-bs-toggle="modal" data-bs-target="#createDataModal">
                            <i class="fa fa-plus"></i> Agregar Registro
                        </div>
                        @endif
                        @endauth
                        @auth
                        @if((Auth::user()->Tipo==="Administrador") || (Auth::user()->Tipo==="SuperAdministrador"))
                        <div class="btn btn-sm btn-info" data-bs-toggle="modal" data-bs-target="#generateSelectionModal">
                            <i class="fa fa-plus"></i> Generar PDF
                        </div>
                        @endif
                        @endauth
                    </div>
                </div>
                <div class="card-body">
                    @include('livewire.registros.modals')
                    <div class="table-responsive">
                        <table class="table table-bordered table-sm mb-5">
                            <thead class="thead">
                                <tr>
                                    <td class="registro_cuerpo">#</td>
                                    <th class="registro_cuerpo">Registro</th>
                                    <th class="registro_cuerpo">Ugel</th>
                                    <th class="registro_cuerpo"> Oficina</th>
                                    <th class="registro_cuerpo"> Usuario</th>
                                    <th class="registro_cuerpo">Descripcion Problema</th>
                                    <th class="registro_cuerpo">Servicio</th>
                                    <th class="registro_cuerpo">Imagen</th>
                                    <th class="registro_cuerpo"> Asignado</th>
                                    <th class="registro_cuerpo">Estado</th>
                                    <th class="registro_cuerpo">Prioridad</th>
                                    <th class="registro_cuerpo">Tipo Soporte</th>
                                    <th class="registro_cuerpo">Solucion</th>
                                    <th class="registro_cuerpo">Fecha Inicio</th>
                                    <th class="registro_cuerpo">Fecha Final</th>
                                    <td class="registro_cuerpo">Eliminar</td>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($registros as $row)
                                    <tr>
                                        <!--
    IMPORTANTE: Se han agregado comillas simples al valor de Cod_Registro en los atributos wire:click.
    Esto asegura que el valor se pase como cadena en lugar de número.
    Sin estas comillas, el valor podría interpretarse como un número en lugar de una cadena.
-->
                                        <td
                                            data-bs-toggle="modal" data-bs-target="#updateDataModal" wire:click="edit('{{ $row->Cod_Registro }}')" >
                                            {{ $loop->iteration }}</td>
                                        <td
                                            data-bs-toggle="modal" data-bs-target="#updateDataModal" wire:click="edit('{{ $row->Cod_Registro }}')"  >
                                            {{ $row->Cod_Registro }}</td>
                                        <td
                                            data-bs-toggle="modal" data-bs-target="#updateDataModal" wire:click="edit('{{ $row->Cod_Registro }}')" >
                                            {{ $row->Nombre_Ugel }}</td>
                                        <td
                                            data-bs-toggle="modal" data-bs-target="#updateDataModal" wire:click="edit('{{ $row->Cod_Registro }}')" >
                                            {{ $row->Nombre_Oficina }}</td>
                                        <td
                                            data-bs-toggle="modal" data-bs-target="#updateDataModal" wire:click="edit('{{ $row->Cod_Registro }}')" >
                                            {{ $row->Nombres_y_Apellidos_Usuario }}</td>
                                        <td
                                            data-bs-toggle="modal" data-bs-target="#updateDataModal" wire:click="edit('{{ $row->Cod_Registro }}')" >
                                            {{ $row->Descripcion_problema }}</td>
                                        <td
                                            data-bs-toggle="modal" data-bs-target="#updateDataModal" wire:click="edit('{{ $row->Cod_Registro }}')" >
                                            {{ $row->Nombre }}</td>
                                        <td data-bs-toggle="modal" data-bs-target="#updateDataModal" wire:click="edit('{{ $row->Cod_Registro }}')">
                                            <div class="image-box">
                                                <!-- Mostrar la imagen desde la ruta almacenada en $this->Imagen -->
                                                @if ($row->Imagen)
                                                    <img class="image-preview" src="{{ asset('storage/' . $row->Imagen) }}?{{ uniqid() }}" style="height: 100px;" alt="Imagen">
                                                @endif
                                            </div>
                                        </td>    
                                        <td
                                            data-bs-toggle="modal" data-bs-target="#updateDataModal" wire:click="edit('{{ $row->Cod_Registro }}')" >
                                            {{ $row->Nombres_y_Apellidos_Tecnico }}</td>
                                        <td
                                            data-bs-toggle="modal" data-bs-target="#updateDataModal" wire:click="edit('{{ $row->Cod_Registro }}')" >
                                            {{ $row->Estado }}</td>
                                        <td
                                            data-bs-toggle="modal" data-bs-target="#updateDataModal" wire:click="edit('{{ $row->Cod_Registro }}')" >
                                            {{ $row->Prioridad }}</td>
                                        <td
                                            data-bs-toggle="modal" data-bs-target="#updateDataModal" wire:click="edit('{{ $row->Cod_Registro }}')" >
                                            {{ $row->Tipo_Soporte }}</td>
                                        <td
                                            data-bs-toggle="modal" data-bs-target="#updateDataModal" wire:click="edit('{{ $row->Cod_Registro }}')" >
                                            {{ $row->Solucion }}</td>

                                        <td
                                            data-bs-toggle="modal" data-bs-target="#updateDataModal" wire:click="edit('{{ $row->Cod_Registro }}')" >
                                            {{ $row->Fecha_Inicio }}</td>
                                        <td
                                            data-bs-toggle="modal" data-bs-target="#updateDataModal" wire:click="edit('{{ $row->Cod_Registro }}')" >
                                            {{ $row->Fecha_Final }}</td>
                                        <td width="90" style="cursor: pointer;">
                                            <a data-bs-toggle="modal" data-bs-target="#deleteConfirmationModal"
                                                class="dropdown-item"
                                                wire:click="confirmDelete('{{ $row->Cod_Registro }}')"><i
                                                    class="fa fa-trash"></i> Eliminar </a>
                                        </td>

                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-center" colspan="100%">No data Found </td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                       
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
