<!DOCTYPE html>
<html>

<head>
    <style>
        /* Estilos CSS para la tabla de registros */
        body {
            font-family: Arial, sans-serif;
        }

        h2 {
            text-align: center;
            margin-top: 50px;
            color: #333;
            margin: 0;
        }
        h1 {
            text-align: center;
            margin-top: 0px;
            color: #333;
        }

        table {
            width: 100%;
            margin-top: 20px;
            border: 1px solid #464343;
        }

        h4 {
            text-align: left;
            margin-top: 0px;
            color: #333;
            margin: 0;
        }

        th,
        td {
            padding: 12px;
            text-align: left;
            border-bottom: 1px solid #ddd;
        }

        th {
            background-color: #5f5a5a;
        }
        .container {
            text-align: center;
        }
        .tabla-intercalada tr:nth-child(even) {
        background-color: rgb(151, 151, 151); /* Gris claro */
        }
        .tabla-intercalada tr:nth-child(odd) {
        background-color: white;
        }
    }
    </style>
    <title>{{$Ugelseleccionada}}_{{$Oficinaseleccionada}}_{{$Usuarioseleccionado}}</title>
</head>
<body>

    <div class="container" style="text-align: center ;height:120px;">
        <img src="https://www.gereducusco.gob.pe/images/varios/logo2022_original.png" class="left-image" style="height: 100%; width: auto; float: left;">
        @if($Ugelseleccionada_logo!='')
            <img src="{{ public_path().'/storage/'.$Ugelseleccionada_logo }}" class="right-image" style="height: 100%; width: auto; float: right;">
        @endif
        <div style="text-align: center;">
            <h2 style="font-size: 20px;">MINISTERIO DE EDUCACIÓN</h2>
            <h2 style="font-size: 20px;">GERENCIA REGIONAL DE EDUCACIÓN CUSCO</h2>
            <h2 style="font-size: 20px;">{{ $Ugelseleccionada }}</h2>
            <h2 style="font-size: 20px;">REGISTROS DEL SISTEMA DE APOYO TECNICO AL USUARIO</h2>
        </div>
        <h2 style="font-size: 20px;"> @if($desde)DESDE: {{ $desde }} @endif @if($hasta)HASTA: {{ $hasta }} @endif</h2>
    </div>
    <table class="tabla-intercalada" style="font-size: 12px; width: 100%; border-collapse: collapse;">
        <thead>
            <tr>
                <td class="registro_cuerpo" style="height: 10px; width: 4%; background-color: rgb(111, 192, 224); text-align: center;">#</td>
                @if($Cod_Registro_check)
                    <th class="registro_cuerpo" style="height: 10px; width: 12%; background-color: rgb(111, 192, 224); text-align: center;">Registro</th>
                @endif
                @if($Ugel_check)
                    <th class="registro_cuerpo" style="height: 10px; width: 8%; background-color: rgb(111, 192, 224); text-align: center;">Ugel</th>
                @endif
                @if($Oficina_check)
                    <th class="registro_cuerpo" style="height: 10px; width: 8%; background-color: rgb(111, 192, 224); text-align: center;">Oficina</th>
                @endif
                
                @if($Usuario_check)
                    <th class="registro_cuerpo" style="height: 10px; width: 8%; background-color: rgb(111, 192, 224); text-align: center;">Usuario</th>
                @endif
                
                @if($Descripcion_check)
                    <th class="registro_cuerpo" style="height: 10px; width: 8%; background-color: rgb(111, 192, 224); text-align: center;">Descripcion Problema</th>
                @endif
                
                @if($Servicio_check)
                    <th class="registro_cuerpo" style="height: 10px; width: 8%; background-color: rgb(111, 192, 224); text-align: center;">Servicio</th>
                @endif
                
                @if($Imagen_check)
                    <th class="registro_cuerpo" style="height: 10px; width: 10%; background-color: rgb(111, 192, 224); text-align: center;">Imagen</th>
                @endif
                
                @if($Asignado_check)
                    <th class="registro_cuerpo" style="height: 10px; width: 8%; background-color: rgb(111, 192, 224); text-align: center;">Asignado</th>
                @endif
                
                @if($Estado_check)
                    <th class="registro_cuerpo" style="height: 10px; width: 8%; background-color: rgb(111, 192, 224); text-align: center;">Estado</th>
                @endif
                
                @if($Prioridad_check)
                    <th class="registro_cuerpo" style="height: 10px; width: 6%; background-color: rgb(111, 192, 224); text-align: center;">Prioridad</th>
                @endif
                
                @if($Soporte_check)
                    <th class="registro_cuerpo" style="height: 10px; width: 8%; background-color: rgb(111, 192, 224); text-align: center;">Tipo Soporte</th>
                @endif
                
                @if($Solucion_check)
                    <th class="registro_cuerpo" style="height: 10px; width: 8%; background-color: rgb(111, 192, 224); text-align: center;">Solucion</th>
                @endif
                
                @if($FechaInicio_check)
                    <th class="registro_cuerpo" style="height: 10px; width: 8%; background-color: rgb(111, 192, 224); text-align: center;">Fecha Inicio</th>
                @endif
                
                @if($FechaFinal_check)
                    <th class="registro_cuerpo" style="height: 10px; width: 8%; background-color: rgb(111, 192, 224); text-align: center;">Fecha Final</th>
                @endif                  
                <!-- Agrega más encabezados según tu estructura de tabla -->
            </tr>
        </thead>
        <tbody>
            @foreach ($registros as $row)
                <tr>
                    <td style="height: 10px; text-align: left; padding: 2px;">{{ $loop->iteration }}</td>
                    @if($Cod_Registro_check)
                        <td style="height: 10px; text-align: left; padding: 2px;">{{ $row->Cod_Registro }}</td>
                    @endif

                    @if($Ugel_check)
                        <td style="height: 10px; text-align: left; padding: 2px;">{{ $row->Nombre_Ugel }}</td>
                    @endif

                    @if($Oficina_check)
                        <td style="height: 10px; text-align: left; padding: 2px;">{{ $row->Nombre_Oficina }}</td>
                    @endif

                    @if($Usuario_check)
                        <td style="height: 10px; text-align: left; padding: 2px;">{{ $row->Nombres_y_Apellidos_Usuario }}</td>
                    @endif

                    @if($Descripcion_check)
                        <td style="height: 10px; text-align: left; padding: 2px;">{{ $row->Descripcion_problema }}</td>
                    @endif

                    @if($Servicio_check)
                        <td style="height: 10px; text-align: left; padding: 2px;">{{ $row->Nombre }}</td>
                    @endif

                    @if($Imagen_check)
                        <td style="height: 10px; text-align: left; padding: 2px;">
                            <div class="image-box">
                                <!-- Mostrar la imagen con tamaño predeterminado -->
                                @if ($row->Imagen)
                                    <img src="{{ public_path().'/storage/'.$row->Imagen }}" style="height: 50px;" alt="Imagen">
                                @endif
                            </div>
                        </td>
                    @endif

                    @if($Asignado_check)
                        <td style="height: 10px; text-align: left; padding: 2px;">{{ $row->Nombres_y_Apellidos_Tecnico }}</td>
                    @endif

                    @if($Estado_check)
                        <td style="height: 10px; text-align: left; padding: 2px;">{{ $row->Estado }}</td>
                    @endif

                    @if($Prioridad_check)
                        <td style="height: 10px; text-align: left; padding: 2px;">{{ $row->Prioridad }}</td>
                    @endif

                    @if($Soporte_check)
                        <td style="height: 10px; text-align: left; padding: 2px;">{{ $row->Tipo_Soporte }}</td>
                    @endif

                    @if($Solucion_check)
                        <td style="height: 10px; text-align: left; padding: 2px;">{{ $row->Solucion }}</td>
                    @endif

                    @if($FechaInicio_check)
                        <td style="height: 10px; text-align: left; padding: 2px;">{{ $row->Fecha_Inicio }}</td>
                    @endif

                    @if($FechaFinal_check)
                        <td style="height: 10px; text-align: left; padding: 2px;">{{ $row->Fecha_Final }}</td>
                    @endif
                    <!-- Agrega más columnas según tu estructura de tabla -->
                </tr>
            @endforeach
        </tbody>
    </table>
    <div style="background-color: rgba(90, 90, 94, 0.644); position: fixed; bottom: 0;margin-bottom:-25px; width: 100%; height: 30px; color: white;">
        <footer class="mt-1" style="margin-top: -10px;">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-6"></div>
                    <div class="col-md-6" style="text-align: right;font-size: 10px">
                        <p style="margin-bottom: 0px; line-height: 1;">
                            <span style="display: inline-block; float: right;">
                                &copy; 2023 Gerencia Regional de Educación Cusco
                                <strong style="font-weight: bold;">Oficina de Centro de Cómputo</strong>.
                                Todos los derechos reservados.
                                <br>
                                Fecha y Hora:{{ $currentDateTime }}
                                <br>
                                URL:{{ $currentURL }}
                            </span>
                        </p>
                        <!-- Agregar el código QR -->
                    </div>
                </div>
            </div>
        </footer>
    </div>
</body>
</html>