<!-- Add Modal -->
<div wire:ignore.self class="modal fade" id="createDataModal" data-bs-backdrop="static" tabindex="-1" role="dialog"
    aria-labelledby="createDataModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl" role="document">
        <div class="modal-content">
            <div class="modal-header formulario_encabezado">
                <h5 class="modal-title" id="createDataModalLabel">Crear Nuevo Registro</h5>
                <button wire:click.prevent="cancel()" type="button" class="btn-close" data-bs-dismiss="modal"
                    aria-label="Close"></button>
            </div>
            <div class="modal-body formulario_cuerpo">
                <form>
                    <div class="row">
                        @auth
                            @if (Auth::user()->Tipo === 'SuperAdministrador')
                                <div class="form-group col-md-4">
                                    <label for="Cod_Ugel" style="color: #800080;">UGEL</label>
                                    <select wire:model="Cod_Ugel" class="form-control" id="Cod_Ugel" placeholder="Ugel">
                                        <option value="">Seleccionar Ugel</option>
                                        @foreach ($ugeles as $ugel)
                                            <option value="{{ $ugel->Cod_Ugel }}">{{ $ugel->Nombre_Ugel }}</option>
                                        @endforeach
                                    </select>
                                    @error('Cod_Ugel')
                                <span class="error text-danger">{{ $message }}</span>
                            @else
                                <small class="error text-info">Campo obligatorio.</small>
                            @enderror
                                </div>
                            @endif
                            @if (Auth::user()->Tipo === 'SuperAdministrador' || Auth::user()->Tipo === 'Administrador')
                                <div class="form-group col-md-4">
                                    <label for="Cod_Oficina" style="color: #800080;">OFICINA</label>
                                    <select wire:model="Cod_Oficina" class="form-control" id="Cod_Oficina"
                                        placeholder="Oficina">
                                        <option value="">Seleccionar Oficina</option>
                                        @foreach ($oficinas as $oficina)
                                            <option value="{{ $oficina->Cod_Oficina }}">{{ $oficina->Nombre_Oficina }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('Cod_Oficina')
                                <span class="error text-danger">{{ $message }}</span>
                            @else
                                <small class="error text-info">Campo obligatorio.</small>
                            @enderror
                                </div>
                            @endif
                            @if (Auth::user()->Tipo === 'SuperAdministrador' || Auth::user()->Tipo === 'Administrador')
                                <div class="form-group col-md-4">
                                    <label for="Usuario" style="color: #800080;">USUARIO</label>
                                    <select wire:model="Usuario" class="form-control" id="Usuario" placeholder="Usuario">
                                        <option value="">Seleccionar Usuario</option>
                                        @foreach ($usuarios as $usuario)
                                            <option value="{{ $usuario->DNI }}">{{ $usuario->Nombres_y_Apellidos }}</option>
                                        @endforeach
                                    </select>
                                    @error('Usuario')
                                        <span class="error text-danger">{{ $message }}</span>
                                    @else
                                        <small class="error text-info">Campo obligatorio.</small>
                                    @enderror
                                </div>
                            @endif
                        @endauth
                    </div>
                    <div class="row">
                        <div class="form-group col-md-6">
                            <label for="Descripcion_problema" style="color: #800080; font-size: 13px;">DESCRIPCION
                                PROBLEMA</label>
                            <textarea wire:model="Descripcion_problema" class="form-control" id="Descripcion_problema"
                                placeholder="Descripcion Problema" rows="8"></textarea>
                            @error('Descripcion_problema')
                                <span class="error text-danger">{{ $message }}</span>
                            @else
                                <small class="error text-info">Maximo 255 caracteres.</small>
                            @enderror
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label style="color: #800080;">TIPO DE SOPORTE</label>
                                <div class="horizontal-options">
                                    <label class="custom-option">
                                        <input class='col-md-2' type="radio" wire:model="Tipo_Soporte"
                                            value="Virtual">
                                        <div class="option-border">Virtual</div>
                                    </label>
                                    <label class="custom-option">
                                        <input type="radio" wire:model="Tipo_Soporte" value="Presencial">
                                        <div class="option-border">Presencial</div>
                                    </label>
                                </div>
                                @error('Tipo_Soporte')
                                    <span class="error text-danger">{{ $message }}</span>
                                @else
                                    <small class="error text-info">Seleccion el Tipo de Soporte.</small>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="imagenInput" style="color: #800080; font-size: 13px;">IMAGEN</label>
                                <input wire:model="imagenInput" type="file" class="form-control" id="imagenInput">
                                @error('imagenInput')
                                    <span class="error text-danger">{{ $message }}</span>
                                @else
                                    <small class="error text-info">Maximo 500KB.</small>
                                @enderror
                            </div>
                            <div class="image-box">
                                <!-- Mostrar la imagen con tamaño predeterminado -->
                                @if ($imagenInput && $imagenInput instanceof Livewire\TemporaryUploadedFile && in_array($imagenInput->getClientOriginalExtension(), ['jpg', 'jpeg', 'png', 'gif']))
                                    <img class="image-preview" src="{{ $imagenInput->temporaryUrl() }}" alt="Imagen">
                                @endif
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <label style="color: #800080;">SERVICIOS HARDWARE</label>
                        <div class="options-grid">
                            @foreach ($servicios_hardware as $servicio)
                                <label class="custom-option">
                                    <input type="radio" wire:model="Servicio"
                                        value="{{ $servicio->Cod_Servicio }}">
                                    <div class="option-border">{{ $servicio->Nombre }}</div>
                                </label>
                            @endforeach
                        </div>

                    </div>
                    <div class="form-group">
                        <label style="color: #800080;">SERVICIOS SOFTWARE</label>
                        <div class="options-grid">
                            @foreach ($servicios_software as $servicio)
                                <label class="custom-option">
                                    <input type="radio" wire:model="Servicio"
                                        value="{{ $servicio->Cod_Servicio }}">
                                    <div class="option-border">{{ $servicio->Nombre }}</div>
                                </label>
                            @endforeach
                        </div>
                        @error('Servicio')
                            <span class="error text-danger">{{ $message }}</span>
                        @else
                            <small class="error text-info">Selecciona un servicio.</small>
                        @enderror
                    </div>
                </form>
            </div>
            <div class="modal-footer formulario_encabezado">
                <button type="button" class="btn btn-secondary close-btn" data-bs-dismiss="modal">Cerrar</button>
                <button type="button" wire:click.prevent="store()" class="btn btn-primary">Guardar</button>
            </div>
        </div>
    </div>
</div>

<!-- Edit Modal -->
<div wire:ignore.self class="modal fade" id="updateDataModal" data-bs-backdrop="static" tabindex="-1"
    role="dialog" aria-labelledby="updateModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl" role="document">
        <div class="modal-content">
            <div class="modal-header formulario_encabezado">
                <h5 class="modal-title" id="updateModalLabel">Actualizar Registro {{ $Cod_Registro }}</h5>
                <button wire:click.prevent="cancel()" type="button" class="btn-close" data-bs-dismiss="modal"
                    aria-label="Close"></button>
            </div>
            <div class="modal-body formulario_cuerpo">
                <form>
                    <div class="row">
                        <div class="form-group col-md-4">
                            <label for="Cod_Ugel" style="color: #800080;">UGEL</label>
                            <select wire:model="Cod_Ugel" class="form-control" id="Cod_Ugel" placeholder="Ugel"
                                @if (Auth::user()->Tipo !== 'SuperAdministrador') disabled @endif>
                                <option value="">Seleccionar Ugel</option>
                                @foreach ($ugeles as $ugel)
                                    <option value="{{ $ugel->Cod_Ugel }}">{{ $ugel->Nombre_Ugel }}</option>
                                @endforeach
                            </select>
                            @error('Cod_Ugel')
                                <span class="error text-danger">{{ $message }}</span>
                            @else
                            @auth
                                @if(Auth::user()->Tipo==="SuperAdministrador")
                                <small class="error text-info">Campo obligatorio.</small>
                                @endif
                            @endauth
                            @enderror
                        </div>
                        <div class="form-group col-md-4">
                            <label for="Cod_Oficina" style="color: #800080;">OFICINA</label>
                            <select wire:model="Cod_Oficina" class="form-control" id="Cod_Oficina"
                                placeholder="Oficina" @if (Auth::user()->Tipo !== 'SuperAdministrador') disabled @endif>
                                <option value="">Seleccionar Oficina</option>
                                @foreach ($oficinas as $oficina)
                                    <option value="{{ $oficina->Cod_Oficina }}">{{ $oficina->Nombre_Oficina }}
                                    </option>
                                @endforeach
                            </select>
                            @error('Cod_Oficina')
                                <span class="error text-danger">{{ $message }}</span>
                            @else
                            @auth
                                @if(Auth::user()->Tipo==="SuperAdministrador")
                                <small class="error text-info">Campo obligatorio.</small>
                                @endif
                            @endauth
                            @enderror
                        </div>
                        <div class="form-group col-md-4">
                            <label for="Usuario" style="color: #800080;">USUARIO</label>
                            <select wire:model="Usuario" class="form-control" id="Usuario" placeholder="Usuario"
                                @if (Auth::user()->Tipo !== 'SuperAdministrador') disabled @endif>
                                <option value="">Seleccionar Usuario</option>
                                @foreach ($usuarios as $usuario)
                                    <option value="{{ $usuario->DNI }}">{{ $usuario->Nombres_y_Apellidos }}
                                    </option>
                                @endforeach
                            </select>
                            @error('Usuario')
                                <span class="error text-danger">{{ $message }}</span>
                            @else
                            @auth
                                @if(Auth::user()->Tipo==="SuperAdministrador")
                                <small class="error text-info">Campo obligatorio.</small>
                                @endif
                            @endauth
                            @enderror
                        </div>
                    </div>
                    <div class="row">
                        <div class="form-group col-md-6">
                            <label for="Descripcion_problema" style="color: #800080; font-size: 13px;">DESCRIPCION
                                PROBLEMA</label>
                            <textarea wire:model="Descripcion_problema" class="form-control" id="Descripcion_problema"
                                placeholder="Descripcion Problema" rows="8" @if (Auth::user()->Tipo === 'Tecnico' ||
                                        Auth::user()->Tipo === 'Administrador' ||
                                        (Auth::user()->Tipo !== 'SuperAdministrador' && $Estado === 'Terminado')) wire:ignore disabled @endif></textarea>
                            @error('Descripcion_problema')
                                <span class="error text-danger">{{ $message }}</span>
                            @else
                            @auth
                                @if(Auth::user()->Tipo==="Usuario" || Auth::user()->Tipo==="SuperAdministrador")
                                    <small class="error text-info">Maximo 255 caracteres.</small>
                                @endif
                            @endauth
                            @enderror
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label style="color: #800080;">TIPO DE SOPORTE</label>
                                <div class="horizontal-options">
                                    <label class="custom-option">
                                        <input type="radio" wire:model="Tipo_Soporte" value="Virtual"
                                            @if (Auth::user()->Tipo === 'Tecnico' ||
                                                    Auth::user()->Tipo === 'Administrador' ||
                                                    (Auth::user()->Tipo !== 'SuperAdministrador' && $Estado === 'Terminado')) wire:ignore disabled @endif>
                                        <div class="option-border">Virtual</div>
                                    </label>
                                    <label class="custom-option">
                                        <input type="radio" wire:model="Tipo_Soporte" value="Presencial"
                                            @if (Auth::user()->Tipo === 'Tecnico' ||
                                                    Auth::user()->Tipo === 'Administrador' ||
                                                    (Auth::user()->Tipo !== 'SuperAdministrador' && $Estado === 'Terminado')) wire:ignore disabled @endif>
                                        <div class="option-border">Presencial</div>
                                    </label>
                                </div>
                                @error('Tipo_Soporte')
                                    <span class="error text-danger">{{ $message }}</span>
                                @else
                                @auth
                                @if(Auth::user()->Tipo==="Usuario" || Auth::user()->Tipo==="SuperAdministrador")
                                    <small class="error text-info">Selecciona una opción.</small>
                                @endif
                            @endauth
                                @enderror
                            </div>

                            <div class="form-group">
                                <label style="color: #800080;">PRIORIDAD</label>
                                <div class="vertical-options">
                                    <label class="custom-option">
                                        <input type="radio" wire:model="Prioridad" value="Alta"
                                            @if (Auth::user()->Tipo !== 'SuperAdministrador') disabled wire:ignore @endif>
                                        <div class="option-border alta">Alta</div>
                                    </label>
                                    <label class="custom-option">
                                        <input type="radio" wire:model="Prioridad" value="Media"
                                            @if (Auth::user()->Tipo !== 'SuperAdministrador') disabled wire:ignore @endif>
                                        <div class="option-border media">Media</div>
                                    </label>
                                    <label class="custom-option">
                                        <input type="radio" wire:model="Prioridad" value="Baja"
                                            @if (Auth::user()->Tipo !== 'SuperAdministrador') disabled wire:ignore @endif>
                                        <div class="option-border baja">Baja</div>
                                    </label>
                                </div>
                                @error('Prioridad')
                                    <span class="error text-danger">{{ $message }}</span>
                                @else
                                @auth
                                @if(Auth::user()->Tipo==="SuperAdministrador")
                                    <small class="error text-info">Selecciona una opción.</small>
                                @endif
                            @endauth
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="imagenInput" style="color: #800080; font-size: 13px;">IMAGEN</label>
                                <input wire:model="imagenInput" type="file" class="form-control" id="imagenInput"  accept="image/jpeg, image/png"
                                    @if (Auth::user()->Tipo === 'Tecnico' ||
                                            Auth::user()->Tipo === 'Administrador' ||
                                            (Auth::user()->Tipo !== 'SuperAdministrador' && $Estado === 'Terminado')) disabled wire:ignore @endif>
                                @error('imagenInput')
                                <span class="error text-danger">{{ $message }}</span>
                            @else
                            @auth
                                @if(Auth::user()->Tipo==="Usuario" || Auth::user()->Tipo==="SuperAdministrador")
                                    <small class="error text-info">Maximo 500KB.</small>
                                @endif
                            @endauth
                            @enderror
                            </div>
                            <div class="image-box">
                                <!-- Mostrar la imagen con tamaño predeterminado -->
                                @if ($imagenInput && $imagenInput instanceof Livewire\TemporaryUploadedFile && in_array($imagenInput->getClientOriginalExtension(), ['jpg', 'jpeg', 'png', 'gif']))
                                    <img class="image-preview" src="{{ $imagenInput->temporaryUrl() }}"
                                        alt="Imagen">
                                @else
                                    <img class="image-preview" src="{{ asset('storage/' . $Imagen) }}?{{ uniqid() }}" alt="Imagen">
                                @endif
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <label style="color: #800080;">SERVICIOS HARDWARE</label>
                        <div class="options-grid">
                            @foreach ($servicios_hardware as $servicio)
                                <label class="custom-option">
                                    <input type="radio" wire:model="Servicio"
                                        value="{{ $servicio->Cod_Servicio }}"
                                        @if (Auth::user()->Tipo === 'Tecnico' ||
                                                Auth::user()->Tipo === 'Administrador' ||
                                                (Auth::user()->Tipo !== 'SuperAdministrador' && $Estado === 'Terminado')) wire:ignore disabled @endif>
                                    <div class="option-border">{{ $servicio->Nombre }}</div>
                                </label>
                            @endforeach
                        </div>
                    </div>
                    <div class="form-group">
                        <label style="color: #800080;">SERVICIOS SOFTWARE</label>
                        <div class="options-grid">
                            @foreach ($servicios_software as $servicio)
                                <label class="custom-option">
                                    <input type="radio" wire:model="Servicio"
                                        value="{{ $servicio->Cod_Servicio }}"
                                        @if (Auth::user()->Tipo === 'Tecnico' ||
                                                Auth::user()->Tipo === 'Administrador' ||
                                                (Auth::user()->Tipo !== 'SuperAdministrador' && $Estado === 'Terminado')) wire:ignore disabled @endif>
                                    <div class="option-border">{{ $servicio->Nombre }}</div>
                                </label>
                            @endforeach
                        </div>
                        @error('Servicio')
                            <span class="error text-danger">{{ $message }}</span>
                        @else
                        @auth
                            @if(Auth::user()->Tipo==="Usuario" || Auth::user()->Tipo==="SuperAdministrador")
                            <small class="error text-info">Selecciona un servicio.</small>
                            @endif
                        @endauth
                        @enderror
                    </div>
                    <div class="row">
                        <div class="form-group col-md-3">
                            <label for="Tecnico_asignado" style="color: #800080;">TECNICO ASIGNADO</label>
                            <select wire:model="Tecnico_asignado" class="form-control" id="Tecnico_asignado"
                                placeholder="Tecnico Asignado"
                                @if (Auth::user()->Tipo !== 'SuperAdministrador') disabled wire:ignore @endif>
                                <option value="">Seleccionar Tecnico</option>
                                @foreach ($tecnicos as $tecnico)
                                    <option value="{{ $tecnico->DNI }}">{{ $tecnico->Nombres_y_Apellidos }}</option>
                                @endforeach
                            </select>
                            @error('Tecnico_asignado')
                                <span class="error text-danger">{{ $message }}</span>
                            @else
                                @auth
                                    @if(Auth::user()->Tipo==="SuperAdministrador")
                                    <small class="error text-info">Seleccione un Tecnico.</small>
                                    @endif
                                @endauth
                            @enderror
                        </div>
                        <div class="form-group col-md-3">
                            <label for="Estado" style="color: #800080; font-size: 13px;">ESTADO</label>
                            <select wire:model="Estado" class="form-control" id="Estado"
                                @if (Auth::user()->Tipo !== 'SuperAdministrador') disabled wire:ignore @endif>
                                <option value="">Seleccionar Estado</option>
                                <option value="Recibido">Recibido</option>
                                <option value="Proceso">Proceso</option>
                                <option value="Terminado">Terminado</option>
                            </select>
                            @error('Tecnico_asignado')
                                <span class="error text-danger">{{ $message }}</span>
                            @enderror
                        </div>
                        <div class="form-group col-md-3">
                            <label for="Fecha_Inicio" style="color: #800080; font-size: 13px;">FECHA INICIO</label>
                            <input wire:model="Fecha_Inicio" type="datetime-local" class="form-control"
                                id="Fecha_Inicio" placeholder="Fecha Inicio"
                                @if (Auth::user()->Tipo !== 'SuperAdministrador') disabled wire:ignore @endif>
                            @error('Fecha_Inicio')
                                <span class="error text-danger">{{ $message }}</span>
                            @enderror
                        </div>
                        <div class="form-group col-md-3">
                            <label for="Fecha_Final" style="color: #800080; font-size: 13px;">FECHA FINAL</label>
                            <input wire:model="Fecha_Final" type="datetime-local" class="form-control"
                                id="Fecha_Final" placeholder="Fecha Final"
                                @if (Auth::user()->Tipo !== 'SuperAdministrador') disabled wire:ignore @endif>
                            @error('Fecha_Final')
                                <span class="error text-danger">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="Solucion" style="color: #800080; font-size: 13px;">SOLUCION</label>
                        <textarea wire:model="Solucion" class="form-control" id="Solucion" placeholder="Solucion" rows="4"
                            @if (Auth::user()->Tipo === 'Administrador' ||
                                    Auth::user()->Tipo === 'Usuario' ||
                                    (Auth::user()->Tipo !== 'SuperAdministrador' && $Estado === 'Terminado')) disabled wire:ignore @endif>
                </textarea>
                        @error('Solucion')
                                <span class="error text-danger">{{ $message }}</span>
                            @else
                            @auth
                                @if(Auth::user()->Tipo==="SuperAdministrador")
                                <small class="error text-info">Maximo 255 caracteres.</small>
                                @endif
                            @endauth
                            @enderror
                    </div>
                </form>
            </div>
            <div class="modal-footer formulario_encabezado">
                <button type="button" wire:click.prevent="cancel()" class="btn btn-secondary"
                    data-bs-dismiss="modal">Cerrar</button>
                <button type="button" wire:click.prevent="update()" class="btn btn-primary">Guardar</button>
            </div>
        </div>
    </div>
</div>
<!-- Delete confirmation modal -->
<div wire:ignore.self class="modal fade" id="deleteConfirmationModal" data-bs-backdrop="static" tabindex="-1"
    role="dialog" aria-labelledby="deleteConfirmationModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header formulario_encabezado">
                <h5 class="modal-title" id="deleteConfirmationModalLabel">Confirmar eliminación</h5>
                <button wire:click.prevent="cancel()" type="button" class="btn-close" data-bs-dismiss="modal"
                    aria-label="Close"></button>
            </div>
            <div class="modal-body formulario_cuerpo">
                ¿Está seguro de que desea eliminar el Registro con Codigo {{ $Cod_Registro }} ?
            </div>
            <div class="modal-footer formulario_encabezado">
                <button type="button" wire:click.prevent="cancel()" class="btn btn-secondary"
                    data-bs-dismiss="modal">Cerrar</button>
                <button type="button" wire:click.prevent="destroy()" class="btn btn-primary"
                    data-bs-dismiss="modal" style="background: red;border-color:red">Eliminar</button>
            </div>
        </div>
    </div>
</div>
<!-- Generate selection modal -->
<div wire:ignore.self class="modal fade" id="generateSelectionModal" data-bs-backdrop="static" tabindex="-1"
    role="dialog" aria-labelledby="generateSelectionModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl" role="document">
        <div class="modal-content">
            <div class="modal-header formulario_encabezado">
                <h5 class="modal-title" id="generateSelectionModalLabel">Seleccione los parametros para generar PDF
                </h5>
                <button wire:click.prevent="cancel()" type="button" class="btn-close" data-bs-dismiss="modal"
                    aria-label="Close"></button>
            </div>
            @auth
                @if (Auth::user()->Tipo === 'Administrador' || Auth::user()->Tipo === 'SuperAdministrador')
                    <div class="container m-2">
                        <!-- Fila para "desde" y "hasta" -->
                        <div class="row">
                            <div class="col-md-4">
                                <label>Desde</label>
                                <input type="date" wire:model="desde" class="form-control">
                            </div>
                            <div class="col-md-4">
                                <label>Hasta</label>
                                <input type="date" wire:model="hasta" class="form-control">
                            </div>
                        </div>
                    </div>
                    <div class="container m-2">
                        <!-- Fila 1 -->
                        <div class="row">
                            <div class="col-md-3">
                                <label>
                                    <input type="checkbox" wire:model="Cod_Registro_check">
                                    Cod. Registro
                                </label>
                            </div>
                            @auth
                                @if (Auth::user()->Tipo === 'SuperAdministrador')
                                    <div class="col-md-3">
                                        <label>
                                            <input type="checkbox" wire:model="Ugel_check">
                                            Ugel
                                        </label>
                                        <select wire:model="Cod_Ugel" class="form-control"
                                            @if (!$Ugel_check) disabled @endif>
                                            <option value="">Seleccionar Ugel</option>
                                            @foreach ($ugeles as $ugel)
                                                <option value="{{ $ugel->Cod_Ugel }}">{{ $ugel->Nombre_Ugel }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                @endif
                            @endauth
                            <div class="col-md-3">
                                <label>
                                    <input type="checkbox" wire:model="Oficina_check">
                                    Oficina
                                </label>
                                <select wire:model="Cod_Oficina" class="form-control" id="Cod_Oficina"
                                    @if (!$Oficina_check) disabled @endif>
                                    <option value="">Seleccionar Oficina</option>
                                    @foreach ($oficinas as $oficina)
                                        <option value="{{ $oficina->Cod_Oficina }}">{{ $oficina->Nombre_Oficina }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-3">
                                <label>
                                    <input type="checkbox" wire:model="Usuario_check">
                                    Usuario
                                </label>
                                <select wire:model="Usuarioseleccionado" class="form-control" id="Usuario"
                                    placeholder="Usuarioseleccionado" @if (!$Usuario_check) disabled @endif>
                                    <option value="">Seleccionar Usuario</option>
                                    @foreach ($usuarios as $usuario)
                                        <option value="{{ $usuario->DNI }}">{{ $usuario->Nombres_y_Apellidos }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                        <!-- Fila 2 -->
                        <div class="row">
                            <div class="col-md-3">
                                <label>
                                    <input type="checkbox" wire:model="Descripcion_check">
                                    Descripción Problema
                                </label>
                            </div>
                            <div class="col-md-3">
                                <label>
                                    <input type="checkbox" wire:model="Servicio_check">
                                    Servicio
                                </label>
                                <select wire:model="Servicioseleccionado" class="form-control"
                                    @if (!$Servicio_check) disabled @endif>
                                    <option value="">Seleccionar Servicio</option>
                                    @foreach ($servicios as $servicio)
                                        <option value="{{ $servicio->Cod_Servicio }}">{{ $servicio->Nombre }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-3">
                                <label>
                                    <input type="checkbox" wire:model="Imagen_check">
                                    Imagen
                                </label>
                            </div>
                            <div class="col-md-3">
                                <label>
                                    <input type="checkbox" wire:model="Asignado_check">
                                    Asignado
                                </label>
                                <select wire:model="Tecnico_asignado" class="form-control" id="Tecnico_asignado"
                                    placeholder="Tecnico Asignado" @if (!$Asignado_check) disabled @endif>
                                    <option value="">Seleccionar Tecnico</option>
                                    @foreach ($tecnicos as $tecnico)
                                        <option value="{{ $tecnico->DNI }}">{{ $tecnico->Nombres_y_Apellidos }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                        <!-- Fila 3 -->
                        <div class="row">
                            <div class="col-md-3">
                                <label>
                                    <input type="checkbox" wire:model="Estado_check">
                                    Estado
                                </label>
                                <select wire:model="Estadoseleccionado" class="form-control"
                                    @if (!$Estado_check) disabled @endif>
                                    <option value="">Seleccionar Estado</option>
                                    <option value="Recibido">Recibido</option>
                                    <option value="Proceso">Proceso</option>
                                    <option value="Terminado">Terminado</option>
                                </select>
                            </div>
                            <div class="col-md-3">
                                <label>
                                    <input type="checkbox" wire:model="Prioridad_check">
                                    Prioridad
                                </label>
                                <select wire:model="Prioridadseleccionada" class="form-control"
                                    @if (!$Prioridad_check) disabled @endif>
                                    <option value="">Seleccionar Prioridad</option>
                                    <option value="Alta">Alta</option>
                                    <option value="Media">Media</option>
                                    <option value="Baja">Baja</option>
                                </select>
                            </div>
                            <div class="col-md-3">
                                <label>
                                    <input type="checkbox" wire:model="Soporte_check">
                                    Soporte
                                </label>
                                <select wire:model="Soporteseleccionado" class="form-control"
                                    @if (!$Soporte_check) disabled @endif>
                                    <option value="">Seleccionar Tipo Soporte</option>
                                    <option value="Virtual">Virtual</option>
                                    <option value="Presencial">Presencial</option>
                                </select>
                            </div>
                            <div class="col-md-3">
                                <label>
                                    <input type="checkbox" wire:model="Solucion_check">
                                    Solución
                                </label>
                            </div>
                        </div>

                        <!-- Fila 4 -->
                        <div class="row">
                            <div class="col-md-3">
                                <label>
                                    <input type="checkbox" wire:model="FechaInicio_check">
                                    Fecha Inicio
                                </label>
                            </div>
                            <div class="col-md-3">
                                <label>
                                    <input type="checkbox" wire:model="FechaFinal_check">
                                    Fecha Final
                                </label>
                            </div>
                        </div>
                    </div>
                @endif
            @endauth
            <div class="modal-footer formulario_encabezado">
                <button type="button" wire:click.prevent="cancel()" class="btn btn-secondary"
                    data-bs-dismiss="modal">Close</button>
                <a href="{{ route('generar.pdf', [
                    'desde' => $desde,
                    'hasta' => $hasta,
                    'Cod_Registro_check' => $Cod_Registro_check,
                    'Ugel_check' => $Ugel_check,
                    'Ugelseleccionada' => $Cod_Ugel,
                    'Oficina_check' => $Oficina_check,
                    'Oficinaseleccionada' => $Cod_Oficina,
                    'Usuario_check' => $Usuario_check,
                    'Usuarioseleccionado' => $Usuarioseleccionado,
                    'Descripcion_check' => $Descripcion_check,
                    'Servicio_check' => $Servicio_check,
                    'Servicioseleccionado' => $Servicioseleccionado,
                    'Imagen_check' => $Imagen_check,
                    'Asignado_check' => $Asignado_check,
                    'Asignadoseleccionado' => $Asignadoseleccionado,
                    'Estado_check' => $Estado_check,
                    'Estadoseleccionado' => $Estadoseleccionado,
                    'Prioridad_check' => $Prioridad_check,
                    'Prioridadseleccionada' => $Prioridadseleccionada,
                    'Soporte_check' => $Soporte_check,
                    'Soporteseleccionado' => $Soporteseleccionado,
                    'Solucion_check' => $Solucion_check,
                    'FechaInicio_check' => $FechaInicio_check,
                    'FechaFinal_check' => $FechaFinal_check,
                    'keyword' => $keyWord,
                ]) }}"
                    class="btn btn-primary" target="_blank">
                    <i class="fa fa-file-pdf-o"></i> Generar PDF
                </a>
            </div>
        </div>
    </div>
</div>
