@section('title', __('Oficinas'))
<div class="container-fluid" style="margin-top: 10px;">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header oficina_encabezado">
                    <div style="display: flex; justify-content: space-between; align-items: center;">
                        <div class="float-left">
                            <h4><i class="fa-fw fas fa-home text-info"></i>
                                Listado de Oficinas </h4>
                        </div>
                        @if (session()->has('message'))
                            <div wire:poll.4s class="btn btn-sm btn-success" style="margin-top:0px; margin-bottom:0px;">
                                {{ session('message') }} </div>
                        @endif
                        <div>
                            <input wire:model='keyWord' type="text" class="form-control" name="search"
                                id="search" placeholder="Buscar en Oficinas">
                        </div>
                        <div class="btn btn-sm btn-info" data-bs-toggle="modal" data-bs-target="#createDataModal">
                            <i class="fa fa-plus"></i> Agregar Oficinas
                        </div>
                    </div>
                </div>

                <div class="card-body">
                    @include('livewire.oficinas.modals')
                    <div class="table-responsive">
                        <table class="table table-bordered table-sm">
                            <thead class="thead">
                                <tr>
                                    <td class="oficina_cuerpo">#</td>
                                    <th class="oficina_cuerpo">Cod Oficina</th>
                                    @auth
                                        @if (Auth::user()->Tipo === 'SuperAdministrador')
                                            <th class="oficina_cuerpo">Ugel</th>
                                        @endif
                                    @endauth
                                    <th class="oficina_cuerpo">Nombre Oficina</th>
                                    <td class="oficina_cuerpo">Eliminar</td>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($oficinas as $row)
                                    <tr>
                                        <td data-bs-toggle="modal" data-bs-target="#updateDataModal"
                                            wire:click="edit('{{ $row->Cod_Oficina }}')">{{ $loop->iteration }}</td>
                                        <td data-bs-toggle="modal" data-bs-target="#updateDataModal"
                                            wire:click="edit('{{ $row->Cod_Oficina }}')">{{ $row->Cod_Oficina }}</td>
                                        @auth
                                            @if (Auth::user()->Tipo === 'SuperAdministrador')
                                                <td data-bs-toggle="modal" data-bs-target="#updateDataModal"
                                                    wire:click="edit('{{ $row->Cod_Oficina }}')">{{ $row->Nombre_Ugel }}
                                                </td>
                                            @endif
                                        @endauth
                                        <td data-bs-toggle="modal" data-bs-target="#updateDataModal"
                                            wire:click="edit('{{ $row->Cod_Oficina }}')">{{ $row->Nombre_Oficina }}</td>
                                        <td width="90" style="cursor: pointer;">
                                            <a data-bs-toggle="modal" data-bs-target="#deleteConfirmationModal"
                                                class="dropdown-item"
                                                wire:click="confirmDelete('{{ $row->Cod_Oficina }}')"><i
                                                    class="fa fa-trash"></i> Eliminar </a>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-center" colspan="100%">No data Found </td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                        <div class="float-end">{{ $oficinas->links() }}</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
