<!-- Add Modal -->
<div wire:ignore.self class="modal fade" id="createDataModal" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="createDataModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header formulario_encabezado">
                <h5 class="modal-title" id="createDataModalLabel">Crear Nueva Oficina</h5>
                <button wire:click.prevent="cancel()" type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
           <div class="modal-body formulario_cuerpo">
				<form>
                    @auth
                    @if(Auth::user()->Tipo==="SuperAdministrador")
                    <div class="form-group">    
                        <label for="Cod_Ugel" style="color: #800080;">UGEL</label>
                        <select wire:model="Cod_Ugel" class="form-control" id="Cod_Ugel"
                            placeholder="Cod Ugel">
                            <option value="">Seleccionar Instituto</option>
                            @foreach ($ugeles as $ugel)
                                <option value="{{ $ugel->Cod_Ugel }}">{{ $ugel->Nombre_Ugel }}</option>
                            @endforeach
                        </select>
                        @error('Cod_Ugel')
                            <span class="error text-danger">{{ $message }}</span>
                        @else
                            <small class="form-text text-info">Campo obligatorio.</small>
                        @enderror
                    </div>
                    @endif
                    @endauth
                    <div class="form-group">
                        <label for="Cod_Oficina" style="color: #800080;">CODIGO OFICINA</label>
                        <input wire:model="Cod_Oficina" type="text" class="form-control" id="Cod_Oficina" placeholder="Cod Oficina">
                        @error('Cod_Oficina')
                            <span class="error text-danger">{{ $message }}</span>
                        @else
                            <small class="form-text text-info">Campo obligatorio y máximo 255 caracteres.</small>
                        @enderror
                    </div>
                    <div class="form-group">
                        <label for="Nombre_Oficina" style="color: #800080;">NOMBRE</label>
                        <input wire:model="Nombre_Oficina" type="text" class="form-control" id="Nombre_Oficina" placeholder="Nombre Oficina">
                        @error('Nombre_Oficina')
                            <span class="error text-danger">{{ $message }}</span>
                        @else
                            <small class="form-text text-info">Campo obligatorio y máximo 255 caracteres.</small>
                        @enderror
                    </div>
                </form>
            </div>
            <div class="modal-footer formulario_encabezado">
                <button type="button" class="btn btn-secondary close-btn" data-bs-dismiss="modal">Cerrar</button>
                <button type="button" wire:click.prevent="store()" class="btn btn-primary">Guardar</button>
            </div>
        </div>
    </div>
</div>

<!-- Edit Modal -->
<div wire:ignore.self class="modal fade" id="updateDataModal" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="updateModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
       <div class="modal-content formulario_cuerpo">
            <div class="modal-header formulario_encabezado">
                <h5 class="modal-title" id="updateModalLabel">Actualizar Oficina</h5>
                <button wire:click.prevent="cancel()" type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form>
					@auth
                    @if(Auth::user()->Tipo==="SuperAdministrador")
                    <div class="form-group">    
                        <label for="Cod_Ugel" style="color: #800080;">UGEL</label>
                        <select wire:model="Cod_Ugel" class="form-control" id="Cod_Ugel"
                            placeholder="Cod Ugel">
                            <option value="">Seleccionar Instituto</option>
                            @foreach ($ugeles as $ugel)
                                <option value="{{ $ugel->Cod_Ugel }}">{{ $ugel->Nombre_Ugel }}</option>
                            @endforeach
                        </select>
                        @error('Cod_Ugel')
                            <span class="error text-danger">{{ $message }}</span>
                        @else
                            <small class="form-text text-info">Campo obligatorio.</small>
                        @enderror
                    </div>
                    @endif
                    @endauth
                    <div class="form-group">
                        <label for="Cod_Oficina" style="color: #800080;">CODIGO OFICINA</label>
                        <input wire:model="Cod_Oficina" type="text" class="form-control" id="Cod_Oficina" placeholder="Cod Oficina">
                        @error('Cod_Oficina')
                            <span class="error text-danger">{{ $message }}</span>
                        @else
                            <small class="form-text text-info">Campo obligatorio y máximo 255 caracteres.</small>
                        @enderror
                    </div>
                    <div class="form-group">
                        <label for="Nombre_Oficina" style="color: #800080;">NOMBRE</label>
                        <input wire:model="Nombre_Oficina" type="text" class="form-control" id="Nombre_Oficina" placeholder="Nombre Oficina">
                        @error('Nombre_Oficina')
                        <span class="error text-danger">{{ $message }}</span>
                    @else
                        <small class="form-text text-info">Campo obligatorio y máximo 255 caracteres.</small>
                    @enderror
                    </div>
                </form>
            </div>
            <div class="modal-footer formulario_encabezado">
                <button type="button" wire:click.prevent="cancel()" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
                <button type="button" wire:click.prevent="update()" class="btn btn-primary">Guardar</button>
            </div>
       </div>
    </div>
</div>
<!-- Delete confirmation modal -->
<div wire:ignore.self class="modal fade" id="deleteConfirmationModal" data-bs-backdrop="static" tabindex="-1" role="dialog"
    aria-labelledby="deleteConfirmationModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content formulario_encabezado">
            <div class="modal-header">
                <h5 class="modal-title" id="deleteConfirmationModalLabel">Confirmar eliminación</h5>
                <button wire:click.prevent="cancel()" type="button" class="btn-close" data-bs-dismiss="modal"
                    aria-label="Close"></button>
            </div>
            <div class="modal-body formulario_cuerpo">
                ¿Está seguro de que desea eliminar la Oficina con Codigo: {{$Cod_Oficina}} ?
            </div>
            <div class="modal-footer formulario_encabezado">
                <button type="button" wire:click.prevent="cancel()" class="btn btn-secondary"
                    data-bs-dismiss="modal">Cancelar</button>
                <button type="button" wire:click.prevent="destroy()" class="btn btn-primary" style="background: red;border-color:red">Eliminar</button>
            </div>
        </div>
    </div>
</div>

