<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>
        @hasSection('title')
            @yield('title') | {{ 'SATU' }}
        @endif
    </title>

    <!-- Fonts -->
    <link rel="dns-prefetch" href="//fonts.gstatic.com">
    <link rel="stylesheet" href="{{ asset('css/app.css') }}">
    <link href="https://fonts.bunny.net/css?family=Nunito" rel="stylesheet">

    <!-- Scripts -->
    @vite(['resources/js/app.js'])
    @livewireStyles
    @inject('gate', 'Illuminate\Contracts\Auth\Access\Gate')
</head>

<body>
    <div id="app">
        <div class="container-fluid h-300">
            <div class="row h-300">
                <aside class="aside col-md-2 h-300 dashboard_cuerpo">
                    <div class="logo" style="margin-top: 10px;">
                        <img src="https://www.gereducusco.gob.pe/images/varios/logo2022_original.png" alt="Logo"
                            height="50" width="45" style="margin-right: 10px">
                        <a href="{{ url('/home') }}">SATU</a>
                    </div>
                    <ul class="navbar-nav">
                        <!-- Menú para usuarios autenticados -->
                        @auth
                            @if (Auth::user()->Tipo === 'SuperAdministrador')
                                <aside-item>
                                    <a href="{{ url('/registros') }}" class="aside-item">
                                        <i class="fa fa-bars" aria-hidden="true"></i> Registros
                                    </a>
                                </aside-item>
                                <aside-item>
                                    <a href="{{ url('/tickets') }}" class="aside-item">
                                        <i class="fa fa-ticket" aria-hidden="true"></i> Tickets
                                    </a>
                                </aside-item>
                                <aside-item>
                                    <a href="{{ url('/oficinas') }}" class="aside-item">
                                        <i class="fa fa-home"aria-hidden="true"></i> Oficinas
                                    </a>
                                </aside-item>
                                <aside-item>
                                    <a href="{{ url('/usuarios') }}" class="aside-item">
                                        <i class="fa fa-users" aria-hidden="true"></i> Usuarios
                                    </a>
                                </aside-item>
                                <aside-item>
                                    <a href="{{ url('/servicios') }}" class="aside-item">
                                        <i class="fa fa-wrench" aria-hidden="true"></i> Servicios
                                    </a>
                                </aside-item>
                                <aside-item>
                                    <a href="{{ url('/ugeles') }}" class="aside-item">
                                        <i class="fa fa-university"aria-hidden="true"></i> Ugeles
                                    </a>
                                </aside-item>
                            @elseif (Auth::user()->Tipo === 'Administrador')
                                <aside-item>
                                    <a href="{{ url('/registros') }}" class="aside-item">
                                        <i class="fa fa-users"aria-hidden="true"></i> Registros
                                    </a>
                                </aside-item>
                                <aside-item>
                                    <a href="{{ url('/tickets') }}" class="aside-item">
                                        <i class="fa fa-ticket" aria-hidden="true"></i> Tickets
                                    </a>
                                </aside-item>
                                <aside-item>
                                    <a href="{{ url('/oficinas') }}" class="aside-item">
                                        <i class="fa fa-home" aria-hidden="true"></i> Oficinas
                                    </a>
                                </aside-item>
                                <aside-item>
                                    <a href="{{ url('/usuarios') }}" class="aside-item">
                                        <i class="fa fa-users" aria-hidden="true"></i> Usuarios
                                    </a>
                                </aside-item>
                                <aside-item>
                                    <a href="{{ url('/servicios') }}" class="aside-item">
                                        <i class="fa fa-wrench" aria-hidden="true"></i> Servicios
                                    </a>
                                </aside-item>
                                <aside-item>
                                    <a href="{{ url('/ugeles') }}" class="aside-item">
                                        <i class="fa fa-university"aria-hidden="true"></i> Ugeles
                                    </a>
                                </aside-item>
                            @elseif (Auth::user()->Tipo === 'Tecnico')
                                <aside-item>
                                    <a href="{{ url('/tickets') }}" class="aside-item">
                                        <i class="fa fa-ticket" aria-hidden="true"></i> Tickets
                                    </a>
                                </aside-item>
                            @elseif (Auth::user()->Tipo === 'Usuario')
                                <aside-item>
                                    <a href="{{ url('/registros') }}" class="aside-item">
                                        <i class="fa fa-users" aria-hidden="true"></i> Registros
                                    </a>
                                </aside-item>
                                <aside-item>
                                    <a href="{{ url('/tickets') }}" class="aside-item">
                                        <i class="fa fa-ticket" aria-hidden="true"></i> Tickets
                                    </a>
                                </aside-item>
                            @endif
                        @endauth
                    </ul>
                    <div class="sidebar-footer">
                        <ul class="navbar-nav ms-auto">
                            <!-- Enlaces de autenticación -->
                            @auth
                                <!-- Menú desplegable del usuario -->
                                <li class="nav-item dropdown">
                                    <a id="navbarDropdown" class="nav-link dropdown-toggle" href="#" role="button"
                                        data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false" v-pre>
                                        {{ Auth::user()->Nombres_y_Apellidos }}
                                    </a>
                                    <div class="dropdown-menu" aria-labelledby="navbarDropdown"
                                        style="background-color: #3b3b3b">
                                        <aside-item>
                                            <a class="dropdown-item" href="{{ route('logout') }}"
                                                onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                                                {{ __('Cerrar sesión') }}
                                            </a>
                                        </aside-item>
                                        <form id="logout-form" action="{{ route('logout') }}" method="POST"
                                            class="d-none">
                                            @csrf
                                        </form>
                                    </div>
                                </li>
                            @endauth
                            <li class="nav-item">
                                <span class="nav-link text-white">Sistema de Apoyo Tecnológico al Usuario</span>
                            </li>
                            <!-- Texto "SATU V(0.1)" -->
                            <li class="nav-item">
                                <span class="nav-link text-white fs-4">SATU V(0.1)</span>
                            </li>
                        </ul>
                    </div>
                </aside>
                <main class="col-md-10 h-300">
                    @if (session('timeout'))
                        <div class="alert alert-danger">
                            {{ session('timeout') }}
                        </div>
                    @endif
                    @yield('content')
                </main>
            </div>
        </div>
    </div>

    <div
        style="background-color: rgba(119, 119, 119, 0.815);position:fixed; bottom: 0; width: 100%; height:45px; color: rgb(0, 0, 0);">
        <div style="position: absolute;">
            <center style="font-size: 8px; opacity: 0.1;color:black;">JAFET CALEB ROJAS GARAY</center>
        </div>
        <footer class="mt-1">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-6">
                    </div>
                    <div class="col-md-6 text-md-end">
                        <p style="margin-bottom: 5px; line-height: 1;">
                            Copyright © 2023 Gerencia Regional de Educación Cusco
                            <strong>Oficina de Centro de Cómputo</strong>.
                        </p>
                        <p style="margin-bottom: 5px; line-height: 1;">
                            Todos los derechos reservados.
                        </p>
                    </div>
                </div>
            </div>
        </footer>
    </div>
    @livewireScripts
<script type="module">
    document.addEventListener('DOMContentLoaded', () => {
        const addModal = document.getElementById('createDataModal');
        const editModal = document.getElementById('updateDataModal');
        const deleteConfirmModal = document.getElementById('deleteConfirmationModal');
        const generateSelectionModal = document.getElementById('generateSelectionModal');

        if (addModal) {
            const addModalInstance = new bootstrap.Modal(addModal);
            window.addEventListener('closeModal', () => {
                addModalInstance.hide();
            });
        }

        if (editModal) {
            const editModalInstance = new bootstrap.Modal(editModal);
            window.addEventListener('closeModal', () => {
                editModalInstance.hide();
            });
        }

        if (deleteConfirmModal) {
            const deleteConfirmModalInstance = new bootstrap.Modal(deleteConfirmModal);
            window.addEventListener('closeModal', () => {
                deleteConfirmModalInstance.hide();
            });
        }

        if (generateSelectionModal) {
            const generateSelectionModalInstance = new bootstrap.Modal(generateSelectionModal);
            window.addEventListener('closeModal', () => {
                generateSelectionModalInstance.hide();
            });
        }
    });
</script>

</body>

</html>
