@extends('layouts.app')
@section('title', __('Bienvenido'))
@section('content')
<div class="container-fluid" style="margin-top: 30px;">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h5><span class="text-center fa fa-home"></span> @yield('title')</h5>
                </div>
                <div class="card-body">
                    <h5>Hola <strong>{{ Auth::user()->name }},</strong> {{ __('tú te has logueado en ') }}{{ config('app.name', 'SATU') }}</h5>
                    <hr>

                    <div class="row w-100">
                        <div class="col-md-3">
							<div class="card border-orange mx-sm-1 p-3 mb-3"> <!-- Cambiado a border-orange -->
								<div class="card border-orange text-orange p-3 my-card"><span class="text-center fa fa-university" aria-hidden="true"></span></div> <!-- Cambiado a text-orange -->
								<div class="text-orange text-center mt-3"><h4>Ugeles</h4></div> <!-- Cambiado a text-orange -->
								<div class="text-orange text-center mt-2"><h1>{{ $ugelesCount }}</h1></div>
							</div>
						</div>						
                        <div class="col-md-3">
                            <div class="card border-warning mx-sm-1 p-3 mb-3">
                                <div class="card border-warning text-warning p-3 my-card"><span class="text-center fa fa-home" aria-hidden="true"></span></div>
                                <div class="text-warning text-center mt-3"><h4>Oficinas</h4></div>
                                <div class="text-warning text-center mt-2"><h1>{{ $oficinasCount }}</h1></div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card border-info mx-sm-1 p-3 mb-3">
                                <div class="card border-info text-info p-3 my-card"><span class="text-center fa fa-wrench" aria-hidden="true"></span></div>
                                <div class="text-info text-center mt-3"><h4>Servicios</h4></div>
                                <div class="text-info text-center mt-2"><h1>{{ $serviciosCount }}</h1></div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card border-danger mx-sm-1 p-3 mb-3">
                                <div class="card border-danger text-danger p-3 my-card"><span class="text-center fa fa-users" aria-hidden="true"></span></div>
                                <div class="text-danger text-center mt-3"><h4>Usuarios</h4></div>
                                <div class="text-danger text-center mt-2"><h1>{{ $userCount }}</h1></div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card border-primary mx-sm-1 p-3 mb-3">
                                <div class="card border-primary text-primary p-3 my-card"><span class="text-center fa fa-bars" aria-hidden="true"></span></div>
                                <div class="text-primary text-center mt-3"><h4>Registros</h4></div>
                                <div class="text-primary text-center mt-2"><h1>{{ $registrosCount }}</h1></div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card border-success mx-sm-1 p-3 mb-3">
                                <div class="card border-success text-success p-3 my-card"><span class="text-center fa fa-ticket" aria-hidden="true"></span></div>
                                <div class="text-success text-center mt-3"><h4>Tickets</h4></div>
                                <div class="text-success text-center mt-2"><h1>{{ $ticketsCount }}</h1></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
