<?php

namespace App\Http\Livewire;

use Livewire\Component;
use Livewire\WithPagination;
use App\Models\User;
use App\Models\Ugele;
use App\Models\Oficina;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Auth;


class Users extends Component
{
    use WithPagination;

    protected $paginationTheme = 'bootstrap';
    public $selected_DNI,$selected_email, $password, $keyWord, $DNI, $Nombres_y_Apellidos, $email, $Tipo, $Cod_Oficina;
    public $NuevaContraseña = false;
    public $ugelseleccionada;

    protected $messages = [
        'DNI.required' => 'El campo DNI es requerido.',
        'DNI.numeric' => 'El campo DNI debe ser un valor numérico.',
        'DNI.digits' => 'El campo DNI debe tener exactamente 8 dígitos.',
        'Nombres_y_Apellidos.required' => 'El campo de Nombres y Apellidos es requerido',
        'Nombres_y_Apellidos.max' => 'El campo de Nombres y Apellidos no debe exceder los 255 caracteres',
        'email.required' => 'El campo de correo es requerido',
        'email.email' => 'El campo debe ser de tipo correo',
        'password.required_if' => 'El campo de contraseña es requerido',
        'password.required' => 'El campo de contraseña es requerido',
        'DNI.unique' => 'El DNI ya existe',
        'email.unique' => 'El Correo ya existe',
        'Tipo.required' => 'El campo de Tipo es requerido',
        'Cod_Oficina.required' => 'El campo de Oficina es requerido',
        'ugelseleccionada.required' => 'El campo de Ugel es requerido',
    ];

    public function render()
    {
        $users = User::all();
        $ugeles = Ugele::all();
        $ugelseleccionada = $this->ugelseleccionada;
        $grupougel = Oficina::where('Cod_Oficina', '=', strval(Auth::user()->Cod_Oficina))->first()->Cod_Ugel;
        if (Auth::user()->Tipo !== 'SuperAdministrador') {
            $oficinas = Oficina::where('Cod_Ugel', $grupougel)->get(); // Aplicamos el filtro aquí solo para cuando no es superadmin
        } else {
            $oficinas = Oficina::where('Cod_Ugel', $ugelseleccionada)->get();
        }

        $keyWord = '%' . $this->keyWord . '%';
        $users = User::select('users.*', 'Nombre_Oficina', 'Nombre_Ugel')
            #unimos con oficinas para filtrar al admin solo usuarios de su ugel
            #ademas para mostrar el nobre de la oficina y tambineunimoscon ugel paramostrar el nombre
            #de la ugel en caso del superadmin
            ->leftJoin('oficinas', 'users.Cod_Oficina', '=', 'oficinas.Cod_Oficina')
            ->leftJoin('ugeles', 'oficinas.Cod_Ugel', '=', 'ugeles.Cod_Ugel')
            #solo se hara este filtro cuando no sea superadministrador
            ->when(Auth::user()->Tipo !== 'SuperAdministrador', function ($query) use ($grupougel) {
                $query->where('oficinas.Cod_Ugel', $grupougel);
            })
            ->where(function ($query) use ($keyWord) {
                $query->where('DNI', 'LIKE', $keyWord)
                    ->orWhere('Nombres_y_Apellidos', 'LIKE', $keyWord)
                    ->orWhere('email', 'LIKE', $keyWord)
                    ->orWhere('Tipo', 'LIKE', $keyWord)
                    ->orWhere('users.Cod_Oficina', 'LIKE', $keyWord)
                    ->orWhere('Nombre_Oficina', 'LIKE', $keyWord)
                    ->orWhere('Nombre_Ugel', 'LIKE', $keyWord);
            })
            ->paginate(10);
        return view('livewire.users.view', [
            'users' => $users,
            'ugeles' => $ugeles,
            'oficinas' => $oficinas,
        ]);
    }

    public function cancel()
    {
        $this->resetInput();
        $this->resetValidation();
    }

    private function resetInput()
    {
        $this->DNI = null;
        $this->Nombres_y_Apellidos = null;
        $this->email = null;
        $this->password = null;
        $this->Tipo = null;
        $this->Cod_Oficina = null;
        $this->ugelseleccionada = null;
        $this->password = null;
    }

    public function store()
    {
        if(Auth::user()->Tipo==="SuperAdministrador"){
            $this->validate([
                'DNI' => 'required|numeric|digits:8|unique:users,DNI',
                'Nombres_y_Apellidos' => 'required|max:255',
                'email' => 'required|email|unique:users,email',
                'Tipo' => 'required',
                'ugelseleccionada' => 'required',
                'Cod_Oficina' => 'required',
                'password' => 'required'
            ]);
        }
        if(Auth::user()->Tipo==="Administrador"){
            $this->validate([
                'DNI' => 'required|numeric|digits:8|unique:users,DNI',
                'Nombres_y_Apellidos' => 'required|max:255',
                'email' => 'required|email|unique:users,email',
                'Tipo' => 'required',
                'Cod_Oficina' => 'required',
                'password' => 'required'
            ]);
        }

        User::create([
            'DNI' => $this->DNI,
            'Nombres_y_Apellidos' => $this->Nombres_y_Apellidos,
            'email' => $this->email,
            'password' => Hash::make($this->password),
            'Tipo' => $this->Tipo,
            'Cod_Oficina' => $this->Cod_Oficina
        ]);

        $this->resetInput();
        $this->dispatchBrowserEvent('closeModal');
        session()->flash('message', 'Usuario Creado Exitosamente');
    }

    public function edit($id)
    {
        $record = User::findOrFail($id);
        $this->selected_DNI = $id;
        $this->DNI = $record->DNI;
        $this->Nombres_y_Apellidos = $record->Nombres_y_Apellidos;
        $this->email = $record->email;
        $this->selected_email = $record->email;
        $this->Tipo = $record->Tipo;
        // Obtener la Cod_Ugel seleccionada
        $this->ugelseleccionada = User::select('oficinas.Cod_Ugel')
            ->leftJoin('oficinas', 'oficinas.Cod_Oficina', '=', 'users.Cod_Oficina')
            ->where('oficinas.Cod_Oficina','=', $record->Cod_Oficina)
            ->value('oficinas.Cod_Ugel'); // Usar value para obtener el valor directamente
        $this->Cod_Oficina = $record->Cod_Oficina;
        $this->resetValidation();
    }

    public function update()
    {
        if(Auth::user()->Tipo==="SuperAdministrador"){
            $this->validate([
                'DNI' => "required|numeric|digits:8|unique:users,DNI,".$this->selected_DNI.",DNI",
                'email' => "required|unique:users,email,".$this->selected_email.",email",
                'Nombres_y_Apellidos' => 'required|max:255',
                'Tipo' => 'required',
                'ugelseleccionada' => 'required',
                'Cod_Oficina' => 'required',
                'password' => 'required_if:NuevaContraseña,true',
            ]);
        }
        if(Auth::user()->Tipo==="Administrador"){
            $this->validate([
                'DNI' => 'required|numeric|digits:8|unique:users,DNI,'.$this->selected_DNI.',DNI',
                'email' => 'required|unique:users,email,'.$this->selected_email.',email',
                'Nombres_y_Apellidos' => 'required|max:255',
                'Tipo' => 'required',
                'Cod_Oficina' => 'required',
                'password' => 'required_if:NuevaContraseña,true',
            ]);
        }
        if ($this->selected_DNI) {
            if ($this->password) {
                $record = User::find($this->selected_DNI);
                $record->update([
                    'DNI' => $this->DNI,
                    'Nombres_y_Apellidos' => $this->Nombres_y_Apellidos,
                    'email' => $this->email,
                    'Tipo' => $this->Tipo,
                    'Cod_Oficina' => $this->Cod_Oficina,
                    'password' => Hash::make($this->password)
                ]);
            } else {
                $record = User::find($this->selected_DNI);
                $record->update([
                    'DNI' => $this->DNI,
                    'Nombres_y_Apellidos' => $this->Nombres_y_Apellidos,
                    'email' => $this->email,
                    'Tipo' => $this->Tipo,
                    'Cod_Oficina' => $this->Cod_Oficina
                ]);
            }
            ;
            $this->resetInput();
            $this->dispatchBrowserEvent('closeModal');
            session()->flash('message', 'Usuario Actualizado Exitosamente.');
        }
    }
    public function confirmDelete($id)
    {
        $record = User::findOrFail($id);
        $this->DNI = $record->DNI;
        $this->resetValidation();
    }
    public function destroy()
    {
        if ($this->DNI) {
            User::where('DNI', $this->DNI)->delete();
            $this->resetInput();
            $this->dispatchBrowserEvent('closeModal');
            session()->flash('message', 'Usuario Eliminado Exitosamente.');
        }
    }
}