<?php

namespace App\Http\Livewire;

use App\Models\Oficina;
use Livewire\Component;
use Livewire\WithPagination;
use App\Models\Ugele;
use Livewire\WithFileUploads;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Auth;

class Ugeles extends Component
{
    use WithPagination;
    use WithFileUploads;

    protected $paginationTheme = 'bootstrap';
    public $selected_Cod, $keyWord, $Cod_Ugel, $Nombre_Ugel, $Logo;
    public $imagenInput;

    protected $messages = [
        'Cod_Ugel.required' => 'El campo RUC es requerido.',
        'Cod_Ugel.numeric' => 'El campo RUC debe ser un valor numérico.',
        'Cod_Ugel.digits' => 'El campo RUC debe tener exactamente 11 dígitos.',
        'Nombre_Ugel.required' => 'El campo de Nombres y Apellidos es requerido',
        'Cod_Ugel.unique' => 'El RUC ya existe',
        'Nombre_Ugel.max' => 'El campo de Nombre no debe exceder los 255 caracteres.',
        'imagenInput.image' => 'El campo Imagen debe ser una imagen.',
        'imagenInput.mimes' => 'El campo Imagen debe ser de tipo jpeg,png,jpg o gif.',
        'imagenInput.max' => 'El campo Imagen debe ser de tamaño 500KB maximos.',
    ];

    public function render()
    {
        $ugeles = Ugele::all();
        $grupougel = Oficina::where('Cod_Oficina', '=', strval(Auth::user()->Cod_Oficina))->first()->Cod_Ugel;
        $keyWord = '%' . $this->keyWord . '%';
        $ugeles = Ugele::when(Auth::user()->Tipo === 'Administrador', function ($query) use ($grupougel) {
            $query->where('Cod_Ugel', $grupougel);
        })
        ->where(function ($query) use ($keyWord) {
            $query->orWhere('Cod_Ugel', 'LIKE', $keyWord)
            ->orWhere('Nombre_Ugel', 'LIKE', $keyWord);
        })
            ->paginate(10);
        return view('livewire.ugeles.view', [
            'ugeles' => $ugeles,
        ]);
    }

    public function cancel()
    {
        $this->resetInput();
    }

    private function resetInput()
    {
        $this->Cod_Ugel = null;
        $this->Nombre_Ugel = null;
        $this->imagenInput=null;
        $this->Logo=null;
    }

    public function store()
    {
        $this->validate([
            'Cod_Ugel' => 'required|numeric|digits:11|unique:ugeles,Cod_Ugel',
            'Nombre_Ugel' => 'required|max:255',
            'imagenInput' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:500',
        ]);
        // Guarda la imagen en la carpeta public/registro_imagenes
        if ($this->imagenInput instanceof \Illuminate\Http\UploadedFile) {
            $imageName = $this->Cod_Ugel . '.' . $this->imagenInput->getClientOriginalExtension();
            $this->imagenInput->storeAs('ugeles_logos', $imageName, 'public');

            // Almacena la ruta de la imagen en $this->imagen
            $this->Logo = 'ugeles_logos/' . $imageName;
        }
        Ugele::create([
            'Cod_Ugel' => $this->Cod_Ugel,
            'Nombre_Ugel' => $this->Nombre_Ugel,
            'Logo'=>$this->Logo
        ]);

        $this->resetInput();
        $this->dispatchBrowserEvent('closeModal');
        session()->flash('message', 'Ugel Creada Exitosamente');
    }

    public function edit($id)
    {
        $record = Ugele::findOrFail($id);
        $this->selected_Cod = $id;
        $this->Cod_Ugel = $record->Cod_Ugel;
        $this->Nombre_Ugel = $record->Nombre_Ugel;
        $this->Logo=$record->Logo;
    }

    public function update()
    {
        $this->validate([
            'Cod_Ugel' => 'required|numeric|digits:11|unique:ugeles,Cod_Ugel,'.$this->selected_Cod.',Cod_Ugel',
            'Nombre_Ugel' => 'required|max:255',
            'imagenInput' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:500',
        ]);
        // Verifica si se proporciona una nueva imagen
        if ($this->imagenInput instanceof \Illuminate\Http\UploadedFile) {
            // Elimina la imagen anterior si existe
            $record = Ugele::find($this->selected_Cod);
            $imagenAnterior = $record->Logo;

            if ($imagenAnterior) {
                Storage::disk('public')->delete($imagenAnterior);
            }

            // Guarda la nueva imagen en la carpeta public/registro_imagenes
            $imageName = $this->Cod_Ugel . '.' . $this->imagenInput->getClientOriginalExtension();
            $this->imagenInput->storeAs('ugeles_logos', $imageName, 'public');
            $this->Logo='ugeles_logos/'. $imageName;
        }
        if ($this->selected_Cod) {
            $record = Ugele::find($this->selected_Cod);
            $record->update([
                'Cod_Ugel' => $this->Cod_Ugel,
                'Nombre_Ugel' => $this->Nombre_Ugel,
                'Logo'=>$this->Logo
            ]);

            $this->resetInput();
            $this->dispatchBrowserEvent('closeModal');
            session()->flash('message', 'Ugel Cctualizada Exitosamente.');
        }
    }
    public function confirmDelete($id)
    {
        $record = Ugele::findOrFail($id);
        $this->Cod_Ugel = $record->Cod_Ugel;
        $this->resetValidation();
    }
    public function destroy()
    {
        if ($this->Cod_Ugel) {
            // Obtener la ruta de la imagen desde la base de datos
            $registro = Ugele::where('Cod_Registro', $this->Cod_Ugel)->first();
            $imagenPath = $registro->Logo;
    
            // Eliminar la imagen almacenada en el sistema de archivos
            if ($imagenPath) {
                Storage::disk('public')->delete($imagenPath);
            }

            Ugele::where('Cod_Ugel', $this->Cod_Ugel)->delete();
            $this->resetInput();
            $this->dispatchBrowserEvent('closeModal');
            session()->flash('message', 'Ugel Eliminada Exitosamente.');
        }
    }
}