<?php

namespace App\Http\Livewire;

use Livewire\Component;
use Livewire\WithPagination;
use App\Models\Servicio;
use App\Models\Ugele;
use App\Models\Oficina;
use Illuminate\Support\Facades\Auth;

class Servicios extends Component
{
    use WithPagination;

    protected $paginationTheme = 'bootstrap';
    public $selected_id, $keyWord, $Cod_Servicio, $Cod_Ugel, $Nombre, $Tipo;

    protected $messages = [
        'Cod_Servicio.required' => 'El campo Cod Servicio es requerido.',
        'Cod_Servicio.max' => 'El campo Cod Servicio no puede exceder los 255 carcateres.',
        'Nombre.required' => 'El campo Nombre es requerido.',
        'Nombre.max' => 'El campo CNombre no puede exceder los 255 carcateres.',
        'Cod_Ugel.required' => 'El campo Cod Ugel es requerido.',
        'Tipo.required' => 'El campo Tipo es requerido.',
    ];

    public function render()
    {
        $ugeles = Ugele::all();
        $grupougel = Oficina::where('Cod_Oficina', '=', strval(Auth::user()->Cod_Oficina))->first()->Cod_Ugel;
        $keyWord = '%' . $this->keyWord . '%';
        $servicios = Servicio::select('servicios.*', 'Nombre_Ugel')
            #unimos con ugel para mostrar la Ugel y el codigo de a ugel
            ->leftJoin('ugeles', 'servicios.Cod_Ugel', '=', 'ugeles.Cod_Ugel')
            #filtramos todas la soficinas quele pertenezcan a la ugel a ucal pertenece el admin
            ->when(Auth::user()->Tipo !== 'SuperAdministrador', function ($query) use ($grupougel) {
                $query->where('servicios.Cod_Ugel', $grupougel);
            })
            ->where(function ($query) use ($keyWord) {
                $query->orWhere('Cod_Servicio', 'LIKE', $keyWord)
                    ->orWhere('Nombre_Ugel', 'LIKE', $keyWord)
                    ->orWhere('servicios.Nombre', 'LIKE', $keyWord)
                    ->orWhere('Tipo', 'LIKE', $keyWord);
            })
            ->paginate(10);
        return view('livewire.servicios.view', [
            'ugeles' => $ugeles,
            'servicios' => $servicios,
        ]);
    }

    public function cancel()
    {
        $this->resetInput();
    }

    private function resetInput()
    {
        $this->Cod_Servicio = null;
        $this->Cod_Ugel = null;
        $this->Nombre = null;
        $this->Tipo = null;
    }

    public function store()
    {
        if(Auth::user()->Tipo==="SuperAdministrador"){
            $this->validate([
                'Cod_Servicio' => 'required|max:255',
                'Nombre' => 'required|max:255',
                'Cod_Ugel' => 'required',
                'Tipo' => 'required',
            ]);
        }
        if(Auth::user()->Tipo==="Administrador"){
            $this->validate([
                'Cod_Servicio' => 'required|max:255',
                'Nombre' => 'required|max:255',
                'Tipo' => 'required',
            ]);
        }
        if (Auth::user()->Tipo === "Administrador") {
            $grupougel = Oficina::where('Cod_Oficina', Auth::user()->Cod_Oficina)->first()->Cod_Ugel;
            $this->Cod_Ugel = $grupougel;
        }

        Servicio::create([
            'Cod_Servicio' => $this->Cod_Servicio,
            'Cod_Ugel' => $this->Cod_Ugel,
            'Nombre' => $this->Nombre,
            'Tipo' => $this->Tipo
        ]);

        $this->resetInput();
        $this->dispatchBrowserEvent('closeModal');
        session()->flash('message', 'Servicio Creado Exitosamente.');
    }

    public function edit($id)
    {
        $record = Servicio::findOrFail($id);
        $this->selected_id = $id;
        $this->Cod_Servicio = $record->Cod_Servicio;
        $this->Cod_Ugel = $record->Cod_Ugel;
        $this->Nombre = $record->Nombre;
        $this->Tipo = $record->Tipo;
    }

    public function update()
    {
        $this->validate([
            'Cod_Servicio' => 'required',
            'Cod_Ugel' => 'required',
            'Nombre' => 'required',
        ]);

        if ($this->selected_id) {
            $record = Servicio::find($this->selected_id);
            $record->update([
                'Cod_Servicio' => $this->Cod_Servicio,
                'Cod_Ugel' => $this->Cod_Ugel,
                'Nombre' => $this->Nombre,
                'Tipo' => $this->Tipo
            ]);

            $this->resetInput();
            $this->dispatchBrowserEvent('closeModal');
            session()->flash('message', 'Servicio Actualizado Exitosamente.');
        }
    }

    public function confirmDelete($id)
    {
        $record = Servicio::findOrFail($id);
        $this->Cod_Servicio = $record->Cod_Servicio;
        $this->resetValidation();
    }
    public function destroy()
    {
        if ($this->Cod_Servicio) {
            Servicio::where('Cod_Servicio', $this->Cod_Servicio)->delete();
            $this->resetInput();
            $this->dispatchBrowserEvent('closeModal');
            session()->flash('message', 'Servicio Eliminado Exitosamente.');
        }
    }
}