<?php

namespace App\Http\Livewire;

use Livewire\Component;
use Livewire\WithPagination;
use App\Models\Registro;
use App\Models\User;
use App\Models\Ugele;
use App\Models\Oficina;
use App\Models\Servicio;
use Carbon\Carbon;
use Livewire\WithFileUploads;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Auth;
use Barryvdh\DomPDF\Facade\Pdf;
use Illuminate\Http\Request;


class Registros extends Component
{
    use WithPagination;
    use WithFileUploads;

    protected $paginationTheme = 'bootstrap';
    public $selected_id, $keyWord, $Cod_Registro, $Cod_Ugel, $Cod_Oficina, $Usuario, $Descripcion_problema, $Tecnico_asignado, $Estado, $Solucion, $Imagen, $imagenInput, $Fecha_Inicio, $Fecha_Final, $Servicio, $Prioridad, $Tipo_Soporte;
    public $desde, $hasta, $Cod_Registro_check, $Ugel_check, $Ugelseleccionada, $Oficina_check, $Oficinaseleccionada, $Usuario_check, $Usuarioseleccionado, $Descripcion_check, $Servicio_check, $Servicioseleccionado, $Imagen_check, $Asignado_check, $Asignadoseleccionado, $Estado_check, $Estadoseleccionado, $Prioridad_check, $Prioridadseleccionada, $Soporte_check, $Soporteseleccionado, $Solucion_check, $FechaInicio_check, $FechaFinal_check;
    public $pdfPath;

    protected $messages = [
        'Cod_Registro.required' => 'El campo Cod Registro es requerido.',
        'Cod_Ugel.required' => 'El campo Cod Ugel es requerido.',
        'Cod_Oficina.required' => 'El campo Cod Ugel es requerido.',
        'Usuario.required' => 'El campo Cod Ugel es requerido.',
        'Descripcion_problema.required' => 'El campo Descripcion es requerido.',
        'Servicio.required' => 'Seleccione un Servicio, es requerido.',
        'Tipo_Soporte.required' => 'Sleecione un Tipo de Soporte, es requerido.',
        'imagenInput.image' => 'El campo Imagen debe ser una imagen.',
        'imagenInput.mimes' => 'El campo Imagen debe ser de tipo jpeg,png,jpg o gif.',
        'imagenInput.max' => 'El campo Imagen debe ser de tamaño 500KB maximos.',
    ];
    
    public function render()
    {
        $grupougel = Oficina::where('Cod_Oficina', '=', strval(Auth::user()->Cod_Oficina))->first()->Cod_Ugel;
        $cod_usuario = Auth::user()->DNI;
        #servicios todos para generar el pdf
        $servicios = Servicio::when(Auth::user()->Tipo === 'SuperAdministrador', function ($query) {
            $query->where('Cod_Ugel', $this->Cod_Ugel);
        })
            ->when(Auth::user()->Tipo !== 'SuperAdministrador', function ($query) use ($grupougel) {
                $query->where('Cod_Ugel', $grupougel);
            })
            ->get();
        #servicios separados para la edicion y el creado
        $servicios_hardware = Servicio::when(Auth::user()->Tipo === 'SuperAdministrador', function ($query) {
            $query->where('Cod_Ugel', $this->Cod_Ugel);
        })
            ->when(Auth::user()->Tipo !== 'SuperAdministrador', function ($query) use ($grupougel) {
                $query->where('Cod_Ugel', $grupougel);
            })
            ->where('Tipo', 'Hardware') // Filtro para servicios de tipo Hardware
            ->get();

        $servicios_software = Servicio::when(Auth::user()->Tipo === 'SuperAdministrador', function ($query) {
            $query->where('Cod_Ugel', $this->Cod_Ugel);
        })
            ->when(Auth::user()->Tipo !== 'SuperAdministrador', function ($query) use ($grupougel) {
                $query->where('Cod_Ugel', $grupougel);
            })
            ->where('Tipo', 'Software') // Filtro para servicios de tipo Software
            ->get();
        #usuarios
        $usuarios = User::leftjoin('oficinas', 'users.Cod_Oficina', '=', 'oficinas.Cod_Oficina')
            ->when(Auth::user()->Tipo === 'Administrador', function ($query) use ($grupougel) {
                $query->where('oficinas.Cod_Ugel', $grupougel);
            })
            ->when(Auth::user()->Tipo === 'SuperAdministrador', function ($query) {
                $query->where('oficinas.Cod_Ugel', $this->Cod_Ugel);
            })
            ->where('users.Tipo','!=', 'SuperAdministrador')
            ->where('users.Cod_Oficina', '=', $this->Cod_Oficina)
            ->select('users.*') // Selecciona todas las columnas de la tabla de usuarios
            ->get();
            
        $tecnicos = User::when(Auth::user()->Tipo === 'Administrador', function ($query) use ($grupougel) {
            $query->whereHas('oficina', function ($query) use ($grupougel) {
                $query->where('Cod_Ugel', $grupougel);
            });
        })
            ->when(Auth::user()->Tipo === 'SuperAdministrador', function ($query) {
                $query->whereHas('oficina', function ($query) {
                    $query->where('Cod_Ugel', $this->Cod_Ugel);
                });
            })
            ->where('Tipo', 'Tecnico')
            ->get();
        $ugeles = Ugele::all();
        #oficinas
        $oficinas = Oficina::when(Auth::user()->Tipo === 'SuperAdministrador', function ($query) {
            $query->where('Cod_Ugel', $this->Cod_Ugel);
        })
            ->when(Auth::user()->Tipo === 'Administrador', function ($query) use ($grupougel) {
                $query->where('Cod_Ugel', $grupougel);
            })
            ->get();

        $keyWord = '%' . $this->keyWord . '%';

        #registros
        $registros = Registro::select('registros.*', 'Nombre_Oficina', 'Nombre_Ugel', 'users.Nombres_y_Apellidos as Nombres_y_Apellidos_Usuario', 'Nombre', 'u_tecnico.Nombres_y_Apellidos as Nombres_y_Apellidos_Tecnico')
            #unimos con user para mostrar el nombre
            ->leftJoin('users', 'registros.Usuario', '=', 'users.DNI')
            #unimos con oficina para mostrar la Oficina
            ->leftJoin('oficinas', 'oficinas.Cod_Oficina', '=', 'registros.Cod_Oficina')
            #unimos con ugel para mostrar la Ugel
            ->leftJoin('ugeles', 'ugeles.Cod_Ugel', '=', 'registros.Cod_Ugel')
            #unimos con usuer para mostrar el tecnico
            ->leftJoin('users as u_tecnico', 'registros.Tecnico_asignado', '=', 'u_tecnico.DNI')
            #unimos con seervicios para mostrar el servicio
            ->leftJoin('servicios', 'registros.Servicio', '=', 'servicios.Cod_Servicio')
            #filtramos todas los registros que le corresponden a la ugel del administrador
            ->when(Auth::user()->Tipo === 'Administrador', function ($query) use ($grupougel) {
                $query->where('registros.Cod_Ugel', $grupougel);
            })
            #filtramos todos los registros que le corresponden al usuario
            ->when(Auth::user()->Tipo === 'Usuario', function ($query) use ($cod_usuario) {
                $query->where('registros.Usuario', $cod_usuario);
            })

            ->where(function ($query) use ($keyWord) {
                $query->where('Cod_Registro', 'LIKE', $keyWord)
                    ->orWhere('Nombre_Ugel', 'LIKE', $keyWord)
                    ->orWhere('Nombre_Oficina', 'LIKE', $keyWord)
                    ->orWhere('Usuario', 'LIKE', $keyWord)
                    ->orWhere('Descripcion_problema', 'LIKE', $keyWord)
                    ->orWhere('Tecnico_asignado', 'LIKE', $keyWord)
                    ->orWhere('Estado', 'LIKE', $keyWord)
                    ->orWhere('Solucion', 'LIKE', $keyWord)
                    ->orWhere('Fecha_Inicio', 'LIKE', $keyWord)
                    ->orWhere('Fecha_Final', 'LIKE', $keyWord);
            })
            ->paginate(10);
        // Formatear las fechas antes de pasar los resultados a la vista
        foreach ($registros as $registro) {
            $registro->Fecha_Inicio = $registro->Fecha_Inicio ? Carbon::parse($registro->Fecha_Inicio)->format('d/m/y H:i:s') : '';
            $registro->Fecha_Final = $registro->Fecha_Final ? Carbon::parse($registro->Fecha_Final)->format('d/m/y H:i:s') : '';
        }

        return view('livewire.registros.view', [
            'registros' => $registros,
            'ugeles' => $ugeles,
            'oficinas' => $oficinas,
            'usuarios' => $usuarios,
            'tecnicos' => $tecnicos,
            'servicios' => $servicios,
            'servicios_hardware' => $servicios_hardware,
            'servicios_software' => $servicios_software,
        ]);
    }

    public function generarPDF(Request $request)
    {
        // Obtén las variables públicas del componente desde la solicitud
        $desde = $request->input('desde');
        $hasta = $request->input('hasta');
        $Cod_Registro_check = $request->input('Cod_Registro_check');
        $Ugel_check = $request->input('Ugel_check');
        $Ugelseleccionada = $request->input('Ugelseleccionada');
        $Oficina_check = $request->input('Oficina_check');
        $Oficinaseleccionada = $request->input('Oficinaseleccionada');
        $Usuario_check = $request->input('Usuario_check');
        $Usuarioseleccionado = $request->input('Usuarioseleccionado');
        $Descripcion_check = $request->input('Descripcion_check');
        $Servicio_check = $request->input('Servicio_check');
        $Servicioseleccionado = $request->input('Servicioseleccionado');
        $Imagen_check = $request->input('Imagen_check');
        $Asignado_check = $request->input('Asignado_check');
        $Asignadoseleccionado = $request->input('Asignadoseleccionado');
        $Estado_check = $request->input('Estado_check');
        $Estadoseleccionado = $request->input('Estadoseleccionado');
        $Prioridad_check = $request->input('Prioridad_check');
        $Prioridadseleccionada = $request->input('Prioridadseleccionada');
        $Soporte_check = $request->input('Soporte_check');
        $Soporteseleccionado = $request->input('Soporteseleccionado');
        $Solucion_check = $request->input('Solucion_check');
        $FechaInicio_check = $request->input('FechaInicio_check');
        $FechaFinal_check = $request->input('FechaFinal_check');
        $keyWord = '%' . $request->input('keyword') . '%';


        $grupougel = Oficina::where('Cod_Oficina', Auth::user()->Cod_Oficina)->first()->Cod_Ugel;
        $cod_usuario = Auth::user()->DNI;
        //en caso del tipo administrador, la ugel seleccionada sera pordefecto el grupougel al que pertenece
        if($Ugelseleccionada=='' || $Ugelseleccionada==null){
            $Ugelseleccionada=$grupougel;
        }
        #registros
        $registros = Registro::select('registros.*', 'Nombre_Oficina', 'Nombre_Ugel', 'users.Nombres_y_Apellidos as Nombres_y_Apellidos_Usuario', 'Nombre', 'u_tecnico.Nombres_y_Apellidos as Nombres_y_Apellidos_Tecnico')
            #unimos con user para mostrar el nombre
            ->leftJoin('users', 'registros.Usuario', '=', 'users.DNI')
            #unimos con oficina para mostrar la Oficina
            ->leftJoin('oficinas', 'oficinas.Cod_Oficina', '=', 'registros.Cod_Oficina')
            #unimos con ugel para mostrar la Ugel
            ->leftJoin('ugeles', 'ugeles.Cod_Ugel', '=', 'registros.Cod_Ugel')
            #unimos con usuer para mostrar el técnico
            ->leftJoin('users as u_tecnico', 'registros.Tecnico_asignado', '=', 'u_tecnico.DNI')
            #unimos con servicios para mostrar el servicio
            ->leftJoin('servicios', 'registros.Servicio', '=', 'servicios.Cod_Servicio')

            #filtramos todos los registros que le corresponden al usuario
            ->when(Auth::user()->Tipo === 'Usuario', function ($query) use ($cod_usuario) {
                $query->where('registros.Usuario', $cod_usuario);
            })
            #filtramos todos los registros según la Ugel seleccionada
            ->when($Ugelseleccionada != "" || $Ugelseleccionada != null, function ($query) use ($Ugelseleccionada) {
                $query->where('registros.Cod_Ugel', $Ugelseleccionada);
            })
            #filtramos todos los registros según la oficina seleccionada
            ->when($Oficinaseleccionada != "" || $Oficinaseleccionada != null, function ($query) use ($Oficinaseleccionada) {
                $query->where('registros.Cod_Oficina', $Oficinaseleccionada);
            })
            #filtramos todos los registros según el usuario seleccionado
            ->when($Usuarioseleccionado != "" || $Usuarioseleccionado != null, function ($query) use ($Usuarioseleccionado) {
                $query->where('registros.Usuario', $Usuarioseleccionado);
            })
            #filtramos todos los registros según el servicio seleccionado
            ->when($Servicioseleccionado != "" || $Servicioseleccionado != null, function ($query) use ($Servicioseleccionado) {
                $query->where('registros.Servicio', $Servicioseleccionado);
            })
            #filtramos todos los registros según el asignado seleccionado
            ->when($Asignadoseleccionado != "" || $Asignadoseleccionado != null, function ($query) use ($Asignadoseleccionado) {
                $query->where('registros.Tecnico_asignado', $Asignadoseleccionado);
            })
            #filtramos todos los registros según el Estado seleccionado
            ->when($Estadoseleccionado != "" || $Estadoseleccionado != null, function ($query) use ($Estadoseleccionado) {
                $query->where('registros.Estado', $Estadoseleccionado);
            })
            #filtramos todos los registros según el Prioridad seleccionado
            ->when($Prioridadseleccionada != "" || $Prioridadseleccionada != null, function ($query) use ($Prioridadseleccionada) {
                $query->where('registros.Prioridad', $Prioridadseleccionada);
            })
            #filtramos todos los registros según el Soporte seleccionado
            ->when($Soporteseleccionado != "" || $Soporteseleccionado != null, function ($query) use ($Soporteseleccionado) {
                $query->where('registros.Tipo_Soporte', $Soporteseleccionado);
            })
            #filtramos todos los registros según la fecha desde
            ->when($desde != "" || $desde != null, function ($query) use ($desde) {
                $query->where('registros.Fecha_Inicio', '>=', $desde);
            })
            #filtramos todos los registros según la fecha hasta
            ->when($hasta != "" || $hasta != null, function ($query) use ($hasta) {
                $query->where('registros.Fecha_Inicio', '<=', $hasta);
            })
            ->where(function ($query) use ($keyWord) {
                $query->where('Cod_Registro', 'LIKE', $keyWord)
                    ->orWhere('Nombre_Ugel', 'LIKE', $keyWord)
                    ->orWhere('Nombre_Oficina', 'LIKE', $keyWord)
                    ->orWhere('Usuario', 'LIKE', $keyWord)
                    ->orWhere('Descripcion_problema', 'LIKE', $keyWord)
                    ->orWhere('Tecnico_asignado', 'LIKE', $keyWord)
                    ->orWhere('Estado', 'LIKE', $keyWord)
                    ->orWhere('Solucion', 'LIKE', $keyWord)
                    ->orWhere('Fecha_Inicio', 'LIKE', $keyWord)
                    ->orWhere('Fecha_Final', 'LIKE', $keyWord);
            })
            ->get();

        // Formatear las fechas antes de pasar los resultados a la vista
        foreach ($registros as $registro) {
            $registro->Fecha_Inicio = $registro->Fecha_Inicio ? Carbon::parse($registro->Fecha_Inicio)->format('d/m/y H:i:s') : '';
            $registro->Fecha_Final = $registro->Fecha_Final ? Carbon::parse($registro->Fecha_Final)->format('d/m/y H:i:s') : '';
        }
        //Formateamos la fecha desde y hasta
        $desde = $desde ? Carbon::parse($desde)->format('d/m/y') : '';
        $hasta = $hasta ? Carbon::parse($hasta)->format('d/m/y') : '';
        // Sacamos el Nombre de la Ugel seleccionada
        $UgelseleccionadaModel = Ugele::where('Cod_Ugel', $Ugelseleccionada)->first();
        $Ugelseleccionada = $UgelseleccionadaModel ? $UgelseleccionadaModel->Nombre_Ugel : '';
        $Ugelseleccionada_logo = $UgelseleccionadaModel ? $UgelseleccionadaModel->Logo : '';
        // Sacamos el Nombre de la Oficina seleccionada
        $OficinaseleccionadaModel = Oficina::where('Cod_Oficina', $Oficinaseleccionada)->first();
        $Oficinaseleccionada = $OficinaseleccionadaModel ? $OficinaseleccionadaModel->Nombre_Oficina : '';
        // Sacamos el Nombre del Usuario seleccionada
        $UsuarioseleccionadoModel = User::where('DNI', $Usuarioseleccionado)->first();
        $Usuarioseleccionado = $UsuarioseleccionadoModel ? $UsuarioseleccionadoModel->Nombres_y_Apellidos : '';
        // Establecer la zona horaria
        date_default_timezone_set('America/Lima'); // Reemplaza 'America/Lima' con la zona horaria correspondiente a tu ubicación
        // Obtener la fecha y hora actual
        $currentDateTime = date('d/m/Y h:i:s A');
        //sacamos la url para mostrarla en el reporte
        $currentURL = \URL::full();
        //creamos nuestro documento pdf con barryvdh/laravel-dompdf
        $pdf=Pdf::loadView('livewire.registros.pdf',compact(
            'registros',
            'currentDateTime',
            'currentURL',
            'desde',
            'hasta',
            'Cod_Registro_check',
            'Ugel_check',
            'Ugelseleccionada',
            'Ugelseleccionada_logo',
            'Oficina_check'  ,
            'Oficinaseleccionada'  ,
            'Usuario_check' ,
            'Usuarioseleccionado' ,
            'Descripcion_check'  ,
            'Servicio_check'  ,
            'Servicioseleccionado'  ,
            'Imagen_check'  ,
            'Asignado_check' ,
            'Asignadoseleccionado'  ,
            'Estado_check' ,
            'Estadoseleccionado'  ,
            'Prioridad_check' ,
            'Prioridadseleccionada'  ,
            'Soporte_check'  ,
            'Soporteseleccionado'  ,
            'Solucion_check'  ,
            'FechaInicio_check'  ,
            'FechaFinal_check'  ,
            'keyWord'
        ));

        // Contar la cantidad de variables _check que son verdaderas o iguales a uno
        $checkedVariables = array(
            $Cod_Registro_check,
            $Ugel_check,
            $Oficina_check,
            $Usuario_check,
            $Descripcion_check,
            $Servicio_check,
            $Imagen_check,
            $Asignado_check,
            $Estado_check,
            $Prioridad_check,
            $Soporte_check,
            $Solucion_check,
            $FechaInicio_check,
            $FechaFinal_check
        );

        $numberOfCheckedVariables = count(array_filter($checkedVariables));
        // Calcular el ancho de la hoja en función de la cantidad de variables _check
        $baseWidth = 297 * 2.8; // Tamaño mínimo
        $maximumWidth = 297 * 4.2; // Tamaño maximo

        if ($numberOfCheckedVariables > 7) {
            $customPaperWidth = $baseWidth + (($numberOfCheckedVariables - 7) / 7) * ($maximumWidth - $baseWidth);
        } else {
            $customPaperWidth = $baseWidth;
        }

        $customPaperHeight = 210 * 2.8;

        $customPaperSize = array(0, 0, $customPaperWidth, $customPaperHeight);

        $pdf->setPaper($customPaperSize);
        // $dompdf->setPaper('A4', 'landscape');

        // Renderizar el PDF
        $pdf->render();
        // Establecer el nombre del archivo PDF
        $filename = $Ugelseleccionada . '_' . $Oficinaseleccionada . '_' . $Usuarioseleccionado . '.pdf';
        // Devolver el PDF al navegador

        return $pdf->stream($filename, ['Attachment' => false]);
    }

    public function cancel()
    {
        $this->resetInput();
    }

    private function resetInput()
    {
        $this->desde = null;
        $this->hasta = null;
        $this->Cod_Registro_check = null;
        $this->Ugel_check = null;
        $this->Ugelseleccionada = null;
        $this->Oficina_check = null;
        $this->Oficinaseleccionada = null;
        $this->Usuario_check = null;
        $this->Usuarioseleccionado = null;
        $this->Descripcion_check = null;
        $this->Servicio_check = null;
        $this->Servicioseleccionado = null;
        $this->Imagen_check = null;
        $this->Asignado_check = null;
        $this->Asignadoseleccionado = null;
        $this->Estado_check = null;
        $this->Estadoseleccionado = null;
        $this->Prioridad_check = null;
        $this->Prioridadseleccionada = null;
        $this->Soporte_check = null;
        $this->Soporteseleccionado = null;
        $this->Solucion_check = null;
        $this->FechaInicio_check = null;
        $this->FechaFinal_check = null;
        $this->keyWord = null;

        $this->Cod_Registro = null;
        $this->Cod_Ugel = null;
        $this->Cod_Oficina = null;
        $this->Usuario = null;
        $this->Descripcion_problema = null;
        $this->Imagen = null;
        $this->Servicio = null;
        $this->Tecnico_asignado = null;
        $this->Estado = null;
        $this->Prioridad = null;
        $this->Tipo_Soporte = null;
        $this->Solucion = null;
        $this->Fecha_Inicio = null;
        $this->Fecha_Final = null;
        $this->imagenInput=null;
    }

    public function store()
    {
        if(Auth::user()->Tipo==="SuperAdministrador"){
            $this->validate([
                'Cod_Registro' => 'required',
                'Cod_Ugel' => 'required',
                'Cod_Oficina' => 'required',
                'Usuario' => 'required',
                'Descripcion_problema' => 'required',
                'Servicio'=>'required',
                'Tipo_Soporte'=>'required',
                'imagenInput' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:500',
            ]);
        }
        if(Auth::user()->Tipo==="Usuario"){
            $this->validate([
                'Descripcion_problema' => 'required',
                'Servicio'=>'required',
                'Tipo_Soporte'=>'required',
                'imagenInput' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:500',
            ]);
        }

        // Obtener la fecha y hora actual
        $this->Fecha_Inicio = date('Y-m-d H:i:s');

        // Inicializamos el Estado
        $this->Estado = 'Recibido';

        if (Auth::user()->Tipo == 'Usuario') {
            //Obtener el codigo de oficina
            $this->Cod_Oficina = Auth::user()->Cod_Oficina;
            //Obtener el codigo de Ugel
            $this->Cod_Ugel = Oficina::where('Cod_Oficina', Auth::user()->Cod_Oficina)->first()->Cod_Ugel;
            //Obtener el usuario
            $this->Usuario = Auth::user()->DNI;
        }
        if (Auth::user()->Tipo == 'Administrador') {
            //Obtener el codigo de Ugel
            if ($this->Cod_Ugel == "" or $this->Cod_Ugel == null) {
                $this->Cod_Ugel = Oficina::where('Cod_Oficina', Auth::user()->Cod_Oficina)->first()->Cod_Ugel;
            }
        }

        //Creac Cod de Registro
        $this->Cod_Registro = $this->Usuario . date('dmYHis');
        // Guarda la imagen en la carpeta public/registro_imagenes
        if ($this->imagenInput instanceof \Illuminate\Http\UploadedFile) {
            $imageName = $this->Cod_Registro . '.' . $this->imagenInput->getClientOriginalExtension();
            $this->imagenInput->storeAs('registros_imagenes', $imageName, 'public');

            // Almacena la ruta de la imagen en $this->imagen
            $this->Imagen = 'registros_imagenes/' . $imageName;
        }
        Registro::create([
            'Cod_Registro' => $this->Cod_Registro,
            'Cod_Ugel' => $this->Cod_Ugel,
            'Cod_Oficina' => $this->Cod_Oficina,
            'Usuario' => $this->Usuario,
            'Descripcion_problema' => $this->Descripcion_problema,
            'Imagen' => $this->Imagen,
            'Servicio' => $this->Servicio,
            'Tecnico_asignado' => $this->Tecnico_asignado,
            'Estado' => $this->Estado,
            'Prioridad' => $this->Prioridad,
            'Tipo_Soporte' => $this->Tipo_Soporte,
            'Solucion' => $this->Solucion,
            'Fecha_Inicio' => $this->Fecha_Inicio,
            'Fecha_Final' => $this->Fecha_Final,
        ]);

        $this->resetInput();
        $this->dispatchBrowserEvent('closeModal');
        session()->flash('message', 'Registro Creado Exitosamente.');
    }

    public function edit($id)
    {
        $record = Registro::findOrFail($id);
        $this->selected_id = $id;
        $this->Cod_Registro = $record->Cod_Registro;
        $this->Cod_Ugel = $record->Cod_Ugel;
        $this->Cod_Oficina = $record->Cod_Oficina;
        $this->Usuario = $record->Usuario;
        $this->Descripcion_problema = $record->Descripcion_problema;
        $this->Servicio = $record->Servicio;
        $this->Imagen = $record->Imagen;
        $this->Tecnico_asignado = $record->Tecnico_asignado;
        $this->Estado = $record->Estado;
        $this->Prioridad = $record->Prioridad;
        $this->Tipo_Soporte = $record->Tipo_Soporte;
        $this->Solucion = $record->Solucion;
        $this->Fecha_Inicio = $record->Fecha_Inicio;
        $this->Fecha_Final = $record->Fecha_Final;
    }

    public function update()
    {
        if(Auth::user()->Tipo==="SuperAdministrador"){
            $this->validate([
                'Cod_Registro' => 'required',
                'Cod_Ugel' => 'required',
                'Cod_Oficina' => 'required',
                'Usuario' => 'required',
                'Descripcion_problema' => 'required',
                'Servicio'=>'required',
                'Tipo_Soporte'=>'required',
                'Fecha_Inicio' => 'required',
                'imagenInput' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:1024',
            ]);
        }
        if(Auth::user()->Tipo==="Usuario"){
            $this->validate([
                'Descripcion_problema' => 'required',
                'Servicio'=>'required',
                'Tipo_Soporte'=>'required',
                'imagenInput' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:1024',
            ]);
        }
        
        // Verifica si se proporciona una nueva imagen
        if ($this->imagenInput instanceof \Illuminate\Http\UploadedFile) {
            // Elimina la imagen anterior si existe
            $record = Registro::find($this->selected_id);
            $imagenAnterior = $record->Imagen;

            if ($imagenAnterior) {
                Storage::disk('public')->delete($imagenAnterior);
            }
            

            // Guarda la nueva imagen en la carpeta public/registro_imagenes
            $imageName = $this->Cod_Registro . '.' . $this->imagenInput->getClientOriginalExtension();
            $this->imagenInput->storeAs('registros_imagenes', $imageName, 'public');
            $this->Imagen='registros_imagenes/'. $imageName;

            // Elimina la carpeta livewire-tmp si existe
            $directorio = 'livewire-tmp';
            if (Storage::disk('public')->exists($directorio)) {
                Storage::disk('public')->deleteDirectory($directorio);
            }
        }
        
        if ($this->Fecha_Final === "") {
            $this->Fecha_Final = null;
        }
        if ($this->selected_id) {
            $record = Registro::find($this->selected_id);
            if (Auth::user()->Tipo === 'SuperAdministrador') {
                $record = Registro::find($this->selected_id);
                $record->update([
                    'Cod_Registro' => $this->Cod_Registro,
                    'Cod_Ugel' => $this->Cod_Ugel,
                    'Cod_Oficina' => $this->Cod_Oficina,
                    'Usuario' => $this->Usuario,
                    'Descripcion_problema' => $this->Descripcion_problema,
                    'Servicio' => $this->Servicio,
                    'Tecnico_asignado' => $this->Tecnico_asignado,
                    'Estado' => $this->Estado,
                    'Prioridad' => $this->Prioridad,
                    'Tipo_Soporte' => $this->Tipo_Soporte,
                    'Solucion' => $this->Solucion,
                    'Fecha_Inicio' => $this->Fecha_Inicio,
                    'Fecha_Final' => $this->Fecha_Final,
                    'Imagen' => $this->Imagen,
                ]);
            }
            if (Auth::user()->Tipo === 'Usuario') {
                $record = Registro::find($this->selected_id);
                $record->update([
                    'Descripcion_problema' => $this->Descripcion_problema,
                    'Tipo_Soporte' => $this->Tipo_Soporte,
                    'Servicio' => $this->Servicio,
                    'Imagen' => $this->Imagen,
                ]);
            }
            if (Auth::user()->Tipo === 'Administrador') {
                $record = Registro::find($this->selected_id);
                $record->update([
                ]);
            }
            $this->resetInput();
            $this->dispatchBrowserEvent('closeModal');
            session()->flash('message', 'Registro Actualizado Exitosamente.');
        }
    }

    public function confirmDelete($id)
    {
        $record = Registro::findOrFail($id);
        $this->Cod_Registro = $record->Cod_Registro;
        $this->resetValidation();
    }
    public function destroy()
    {
        if ($this->Cod_Registro) {
            // Obtener la ruta de la imagen desde la base de datos
            $registro = Registro::where('Cod_Registro', $this->Cod_Registro)->first();
            $imagenPath = $registro->Imagen;
    
            // Eliminar la imagen almacenada en el sistema de archivos
            if ($imagenPath) {
                Storage::disk('public')->delete($imagenPath);
            }
    
            // Eliminar el registro de la base de datos
            Registro::where('Cod_Registro', $this->Cod_Registro)->delete();
    
            $this->resetInput();
            $this->dispatchBrowserEvent('closeModal');
            session()->flash('message', 'Registro eliminado exitosamente.');
        }
    }
    
}