<?php

namespace App\Http\Livewire;

use Livewire\Component;
use Livewire\WithPagination;
use App\Models\Oficina;
use App\Models\Ugele;
use Illuminate\Support\Facades\Auth;

class Oficinas extends Component
{
    use WithPagination;

    protected $paginationTheme = 'bootstrap';
    public $selected_id, $keyWord, $Cod_Oficina, $Nombre_Oficina, $Cod_Ugel;

    protected $messages = [
        'Cod_Oficina.required' => 'El campo Cod Registro es requerido.',
        'Cod_Oficina.max' => 'El campo Cod Registro no debe esceder los 255 caracteres.',
        'Nombre_Oficina.required' => 'El campo Cod Ugel es requerido.',
        'Nombre_Oficina.max' => 'El campo Cod Ugel no debe exceder los 255 caracteres.',
        'Cod_Ugel.required' => 'El campo Cod Ugel es requerido.',
    ];

    public function render()
    {
        $oficinas = Oficina::all();
        $grupougel = Oficina::where('Cod_Oficina', '=', strval(Auth::user()->Cod_Oficina))->first()->Cod_Ugel;
        $ugeles = Ugele::all();
        $keyWord = '%' . $this->keyWord . '%';
        $oficinas = Oficina::select('oficinas.*', 'Nombre_Ugel')
            #unimos con ugel para mostrar la Ugel y el codigo de a ugel
            ->leftJoin('ugeles', 'oficinas.Cod_Ugel', '=', 'ugeles.Cod_Ugel')
            #filtramos todas la soficinas quele pertenezcan a la ugel a ucal pertenece el admin
            ->when(Auth::user()->Tipo !== 'SuperAdministrador', function ($query) use ($grupougel) {
                $query->where('oficinas.Cod_Ugel', $grupougel);
            })
            ->where(function ($query) use ($keyWord) {
                $query->where('Cod_Oficina', 'LIKE', $keyWord)
                    ->orWhere('Nombre_Oficina', 'LIKE', $keyWord)
                    ->orWhere('Nombre_Ugel', 'LIKE', $keyWord);
            })
            ->paginate(10);

        return view('livewire.oficinas.view', [
            'oficinas' => $oficinas,
            'ugeles' => $ugeles,
        ]);
    }

    public function cancel()
    {
        $this->resetInput();
    }

    private function resetInput()
    {
        $this->Cod_Oficina = null;
        $this->Nombre_Oficina = null;
        $this->Cod_Ugel = null;
    }

    public function store()
    {
        if(Auth::user()->Tipo==="SuperAdministrador"){
            $this->validate([
                'Cod_Oficina' => 'required|max:255',
                'Nombre_Oficina' => 'required|max:255',
                'Cod_Ugel' => 'required',
            ]);
        }
        if(Auth::user()->Tipo==="Administrador"){
            $this->validate([
                'Cod_Oficina' => 'required|max:255',
                'Nombre_Oficina' => 'required|max:255',
            ]);
        }
        if (Auth::user()->Tipo === "Administrador") {
            $grupougel = Oficina::where('Cod_Oficina', Auth::user()->Cod_Oficina)->first()->Cod_Ugel;
            $this->Cod_Ugel = $grupougel;
        }
        Oficina::create([
            'Cod_Oficina' => $this->Cod_Oficina,
            'Nombre_Oficina' => $this->Nombre_Oficina,
            'Cod_Ugel' => $this->Cod_Ugel
        ]);

        $this->resetInput();
        $this->dispatchBrowserEvent('closeModal');
        session()->flash('message', 'Oficina Creada Exitosamente.');
    }

    public function edit($id)
    {
        $record = Oficina::findOrFail($id);
        $this->selected_id = $id;
        $this->Cod_Oficina = $record->Cod_Oficina;
        $this->Nombre_Oficina = $record->Nombre_Oficina;
        $this->Cod_Ugel = $record->Cod_Ugel;
    }

    public function update()
    {
        if(Auth::user()->Tipo==="SuperAdministrador"){
            $this->validate([
                'Cod_Oficina' => 'required',
                'Nombre_Oficina' => 'required',
                'Cod_Ugel' => 'required',
            ]);
        }
        if(Auth::user()->Tipo==="Administrador"){
            $this->validate([
                'Cod_Oficina' => 'required',
                'Nombre_Oficina' => 'required',
            ]);
        }

        if ($this->selected_id) {
            $record = Oficina::find($this->selected_id);
            $record->update([
                'Cod_Oficina' => $this->Cod_Oficina,
                'Nombre_Oficina' => $this->Nombre_Oficina,
                'Cod_Ugel' => $this->Cod_Ugel
            ]);

            $this->resetInput();
            $this->dispatchBrowserEvent('closeModal');
            session()->flash('message', 'Oficina Actualizada Exitosamente.');
        }
    }
    public function confirmDelete($id)
    {
        $record = Oficina::findOrFail($id);
        $this->Cod_Oficina = $record->Cod_Oficina;
        $this->resetValidation();
    }
    public function destroy()
    {
        if ($this->Cod_Oficina) {
            Oficina::where('Cod_Oficina', $this->Cod_Oficina)->delete();
            $this->resetInput();
            $this->dispatchBrowserEvent('closeModal');
            session()->flash('message', 'Oficina Eliminada Exitosamente.');
        }
    }
}